/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.jira;

import com.atlassian.confluence.content.render.xhtml.RenderedContentCleaner;
import com.atlassian.confluence.extra.jira.Channel;
import com.atlassian.confluence.extra.jira.FlexigridResponseGenerator;
import com.atlassian.confluence.extra.jira.JiraIssuesManager;
import com.atlassian.confluence.extra.jira.api.services.JiraIssuesColumnManager;
import com.atlassian.confluence.extra.jira.api.services.JiraIssuesDateFormatter;
import com.atlassian.confluence.extra.jira.columns.JiraIssuesXmlTransformer;
import com.atlassian.confluence.extra.jira.util.JiraIssueDateUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFlexigridResponseGenerator
implements FlexigridResponseGenerator {
    private static final Logger log = LoggerFactory.getLogger(JsonFlexigridResponseGenerator.class);
    private static final String DUE_DATE_CONSTANT = "due";
    private final JiraIssuesXmlTransformer xmlXformer;
    private final I18nResolver i18nResolver;
    private final JiraIssuesManager jiraIssuesManager;
    private final JiraIssuesColumnManager jiraIssuesColumnManager;
    private final JiraIssuesDateFormatter jiraIssuesDateFormatter;
    private final TimeZoneManager timeZoneManager;
    private Locale userLocale;
    private final RenderedContentCleaner renderedContentCleaner;

    public JsonFlexigridResponseGenerator(I18nResolver i18nResolver, JiraIssuesManager jiraIssuesManager, JiraIssuesColumnManager jiraIssuesColumnManager, JiraIssuesDateFormatter jiraIssuesDateFormatter, TimeZoneManager timeZoneManager, RenderedContentCleaner renderedContentCleaner) {
        this.i18nResolver = i18nResolver;
        this.jiraIssuesManager = jiraIssuesManager;
        this.jiraIssuesColumnManager = jiraIssuesColumnManager;
        this.jiraIssuesDateFormatter = jiraIssuesDateFormatter;
        this.renderedContentCleaner = renderedContentCleaner;
        this.xmlXformer = new JiraIssuesXmlTransformer(this.jiraIssuesManager, this.renderedContentCleaner);
        this.timeZoneManager = timeZoneManager;
    }

    public boolean handles() {
        return true;
    }

    private String getText(String i18nKey) {
        return this.i18nResolver.getText(i18nKey);
    }

    private String createImageTag(String iconUrl, String altText) {
        StringBuilder imageTagBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)iconUrl)) {
            imageTagBuilder.append("<img src=\"").append(iconUrl).append("\" alt=\"").append(altText).append("\"/>");
        }
        return imageTagBuilder.toString();
    }

    protected String getElementJson(Element itemElement, Collection<String> columnNames, Map<String, String> columnMap, boolean fromApplink) {
        Element keyElement = itemElement.getChild("key");
        String key = null != keyElement ? keyElement.getValue() : "";
        String link = itemElement.getChild("link").getValue();
        StringBuilder jsonIssueElementBuilder = new StringBuilder();
        jsonIssueElementBuilder.append("{id:'").append(key).append("',cell:[");
        Iterator<String> columnNamesIterator = columnNames.iterator();
        while (columnNamesIterator.hasNext()) {
            String columnName = columnNamesIterator.next();
            if (this.jiraIssuesColumnManager.isBuiltInColumnMultivalue(columnName)) {
                this.appendMultivalueBuiltinColumn(itemElement, columnName, jsonIssueElementBuilder);
            } else {
                String value;
                Element child = itemElement.getChild(columnName);
                String string = value = null != child ? child.getValue() : "";
                if (!(columnName.equalsIgnoreCase("created") || columnName.equalsIgnoreCase("updated") || columnName.equalsIgnoreCase(DUE_DATE_CONSTANT))) {
                    value = StringEscapeUtils.escapeEcmaScript((String)StringEscapeUtils.escapeHtml4((String)value));
                }
                if (columnName.equalsIgnoreCase("type")) {
                    jsonIssueElementBuilder.append("'<a href=\"").append(link).append("\" >").append(this.createImageTag(this.xmlXformer.findIconUrl(child), value)).append("</a>'");
                } else if (columnName.equalsIgnoreCase("key") || columnName.equals("summary")) {
                    jsonIssueElementBuilder.append("'<a href=\"").append(link).append("\" >").append(value).append("</a>'");
                } else if (columnName.equalsIgnoreCase("priority")) {
                    jsonIssueElementBuilder.append("'").append(this.createImageTag(this.xmlXformer.findIconUrl(child), value)).append("'");
                } else if (columnName.equalsIgnoreCase("status")) {
                    this.appendIssueStatus(child, value, jsonIssueElementBuilder);
                } else if (columnName.equalsIgnoreCase("created") || columnName.equalsIgnoreCase("updated")) {
                    this.appendIssueDate(value, jsonIssueElementBuilder);
                } else if (columnName.equalsIgnoreCase(DUE_DATE_CONSTANT)) {
                    String createdValue = itemElement.getChild("created") != null ? itemElement.getChild("created").getValue() : null;
                    String correctedDueDate = JiraIssueDateUtil.applyDateFixes(this.jiraIssuesDateFormatter, value, createdValue, this.getUserLocale());
                    this.appendDueDate(correctedDueDate, jsonIssueElementBuilder, fromApplink);
                } else if (columnName.equals("description")) {
                    fieldValue = this.xmlXformer.valueForField(itemElement, columnName, columnMap);
                    String description = fieldValue.getValue();
                    if (!fromApplink) {
                        description = HtmlUtil.htmlEncode((String)description);
                    }
                    jsonIssueElementBuilder.append("'").append(StringEscapeUtils.escapeEcmaScript((String)description)).append("'");
                } else if (this.jiraIssuesColumnManager.isColumnBuiltIn(columnName)) {
                    fieldValue = this.xmlXformer.valueForField(itemElement, columnName, columnMap);
                    jsonIssueElementBuilder.append("'").append(HtmlUtil.htmlEncode((String)fieldValue.getValue())).append("'");
                } else {
                    this.appendCustomField(itemElement, columnMap, columnName, jsonIssueElementBuilder, fromApplink);
                }
            }
            if (columnNamesIterator.hasNext()) {
                jsonIssueElementBuilder.append(',');
                continue;
            }
            jsonIssueElementBuilder.append("]}\n");
        }
        return jsonIssueElementBuilder.toString();
    }

    private void appendCustomField(Element itemElement, Map<String, String> columnMap, String columnName, StringBuilder jsonIssueElementBuilder, boolean fromApplink) {
        block7: {
            Element fieldValue = this.xmlXformer.valueForField(itemElement, columnName, columnMap);
            String fieldValueText = fieldValue.getValue();
            if (StringUtils.isNotBlank((CharSequence)fieldValueText)) {
                String date = this.jiraIssuesDateFormatter.reformatDateInUserLocale(fieldValueText, this.getUserLocale(), "dd/MMM/yy");
                if (StringUtils.isNotEmpty((CharSequence)date)) {
                    jsonIssueElementBuilder.append("'").append(date).append("'");
                } else {
                    try {
                        String convertedDate = this.jiraIssuesDateFormatter.reformatDateInDefaultLocale(fieldValueText, this.getUserLocale(), "dd/MMM/yy");
                        if (StringUtils.isNotBlank((CharSequence)convertedDate)) {
                            jsonIssueElementBuilder.append("'").append(convertedDate).append("'");
                            break block7;
                        }
                        this.appendCustomFieldUnformatted(fieldValueText, jsonIssueElementBuilder, fromApplink);
                    }
                    catch (DateTimeParseException pe) {
                        log.debug("Unable to parse {} into a date", (Object)fieldValue.getText(), (Object)pe);
                        this.appendCustomFieldUnformatted(fieldValueText, jsonIssueElementBuilder, fromApplink);
                    }
                }
            } else {
                this.appendCustomFieldUnformatted(fieldValueText, jsonIssueElementBuilder, fromApplink);
            }
        }
    }

    private void appendCustomFieldUnformatted(String fieldValueText, StringBuilder jsonIssueElementBuilder, boolean fromAppLink) {
        if (!fromAppLink) {
            fieldValueText = StringEscapeUtils.escapeHtml4((String)fieldValueText);
        }
        jsonIssueElementBuilder.append("'").append(StringEscapeUtils.escapeEcmaScript((String)fieldValueText)).append("'");
    }

    private void appendDueDate(String value, StringBuilder jsonIssueElementBuilder, boolean fromApplink) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            jsonIssueElementBuilder.append("''");
            return;
        }
        if (JiraIssueDateUtil.isValidDate(value, this.getUserLocale())) {
            log.debug("The provided date is a valid date in the user locale: {}", (Object)value);
            jsonIssueElementBuilder.append("'").append(value).append("'");
            return;
        }
        log.debug("The provided date is NOT a valid date in the user locale: {}", (Object)value);
        this.appendCustomFieldUnformatted(value, jsonIssueElementBuilder, fromApplink);
    }

    private void appendIssueDate(String value, StringBuilder jsonIssueElementBuilder) throws DateTimeParseException {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            ZonedDateTime mailFormatDate = ZonedDateTime.parse(value.trim(), JiraIssueDateUtil.MAIL_DATE_TIME_FORMATTER.withLocale(this.getUserLocale()));
            String dateTimeValue = mailFormatDate.format(JiraIssueDateUtil.DATE_TIME_VALUE_FORMATTER.withLocale(this.getUserLocale()).withZone(this.timeZoneManager.getUserTimeZone().toZoneId()));
            jsonIssueElementBuilder.append("'").append(dateTimeValue).append("'");
        } else {
            jsonIssueElementBuilder.append("''");
        }
    }

    private void appendIssueStatus(Element child, String value, StringBuilder jsonIssueElementBuilder) {
        String imgTag = this.createImageTag(this.xmlXformer.findIconUrl(child), value);
        jsonIssueElementBuilder.append("'");
        if (StringUtils.isNotBlank((CharSequence)imgTag)) {
            jsonIssueElementBuilder.append(imgTag).append(" ");
        }
        jsonIssueElementBuilder.append(value).append("'");
    }

    private void appendMultivalueBuiltinColumn(Element itemElement, String columnName, StringBuilder jsonIssueElementBuilder) {
        jsonIssueElementBuilder.append("'");
        String fieldValue = StringEscapeUtils.escapeEcmaScript((String)this.xmlXformer.collapseMultiple(itemElement, columnName).getValue());
        jsonIssueElementBuilder.append(HtmlUtil.htmlEncode((String)fieldValue));
        jsonIssueElementBuilder.append("'");
    }

    private String getOutputAsString(String url, Channel jiraResponseChannel, Collection<String> columnNames, int requestedPage, boolean showCount, boolean fromApplink) {
        String count;
        Element jiraResponseElement = jiraResponseChannel.getChannelElement();
        HashMap<String, String> columnMap = new HashMap<String, String>();
        List itemElements = jiraResponseElement.getChildren("item");
        String language = jiraResponseElement.getChildText("language");
        if (StringUtils.isNotEmpty((CharSequence)language)) {
            if (language.contains("-")) {
                this.setUserLocale(new Locale(language.substring(0, 2), language.substring(language.indexOf(45) + 1)));
            } else {
                this.setUserLocale(new Locale(language));
            }
        } else {
            this.setUserLocale(Locale.getDefault());
        }
        Element totalItemsElement = jiraResponseElement.getChild("issue");
        String string = count = totalItemsElement != null ? totalItemsElement.getAttributeValue("total") : String.valueOf(itemElements.size());
        if (showCount) {
            return count;
        }
        StringBuilder jiraResponseJsonBuilder = new StringBuilder();
        String trustedMessage = null;
        if (StringUtils.isNotBlank(trustedMessage)) {
            trustedMessage = jiraResponseJsonBuilder.append("'").append(StringEscapeUtils.escapeEcmaScript(trustedMessage)).append("'").toString();
            jiraResponseJsonBuilder.setLength(0);
        }
        jiraResponseJsonBuilder.append("{\npage: ").append(requestedPage).append(",\n").append("total: ").append(count).append(",\n").append("trustedMessage: ").append(trustedMessage).append(",\n").append("rows: [\n");
        Iterator itemIterator = itemElements.iterator();
        while (itemIterator.hasNext()) {
            jiraResponseJsonBuilder.append(this.getElementJson((Element)itemIterator.next(), columnNames, columnMap, fromApplink));
            if (itemIterator.hasNext()) {
                jiraResponseJsonBuilder.append(',');
            }
            jiraResponseJsonBuilder.append('\n');
        }
        jiraResponseJsonBuilder.append("]}");
        this.jiraIssuesManager.setColumnMap(url, columnMap);
        return jiraResponseJsonBuilder.toString();
    }

    @Override
    public String generate(Channel jiraResponseChannel, Collection<String> columnNames, int requestedPage, boolean showCount, boolean fromApplink) throws IOException {
        try {
            return this.getOutputAsString(jiraResponseChannel.getSourceUrl(), jiraResponseChannel, columnNames, requestedPage, showCount, fromApplink);
        }
        catch (Exception e) {
            throw new IOException("Unable to generate JSON output", e);
        }
    }

    public Locale getUserLocale() {
        return this.userLocale;
    }

    public void setUserLocale(Locale userLocale) {
        this.userLocale = userLocale;
    }
}

