/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.jira.columns;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.AuthorisationURIGenerator;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.auth.Anonymous;
import com.atlassian.confluence.extra.jira.Channel;
import com.atlassian.confluence.extra.jira.JiraIssuesManager;
import com.atlassian.confluence.extra.jira.api.services.JiraIssuesColumnManager;
import com.atlassian.confluence.extra.jira.api.services.JiraIssuesUrlManager;
import com.atlassian.confluence.extra.jira.api.services.JiraResponseHandler;
import com.atlassian.confluence.extra.jira.applink.JiraAppLinkResponseHandler;
import com.atlassian.confluence.extra.jira.request.JiraChannelResponseHandler;
import com.atlassian.confluence.extra.jira.request.JiraStringResponseHandler;
import com.atlassian.confluence.extra.jira.util.JiraUtil;
import com.atlassian.confluence.plugins.jira.beans.BasicJiraIssueBean;
import com.atlassian.confluence.plugins.jira.beans.JiraIssueBean;
import com.atlassian.integration.jira.JiraService;
import com.atlassian.plugins.whitelist.NotAuthorizedException;
import com.atlassian.plugins.whitelist.OutboundWhitelist;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJiraIssuesManager
implements JiraIssuesManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJiraIssuesManager.class);
    private static final String CREATE_JIRA_ISSUE_URL = "/rest/api/2/issue/";
    private static final String CREATE_JIRA_ISSUE_BATCH_URL = "/rest/api/2/issue/bulk";
    private static final String REST_JQL_JVIS_DC_PATH = "/rest/api/2/search";
    private static final String REST_JQL_JSIS_CLOUD_PATH = "/rest/api/2/search/jql";
    private static final int CONNECTION_TIMEOUT = Integer.parseInt(System.getProperty("confluence.jira.connection.timeout", "30000"));
    private final JiraIssuesColumnManager jiraIssuesColumnManager;
    private final JiraIssuesUrlManager jiraIssuesUrlManager;
    private final RequestFactory<?> requestFactory;
    private final OutboundWhitelist outboundWhitelist;
    private final JiraService jiraService;
    private LoadingCache<ReadOnlyApplicationLink, Boolean> batchIssueCapableCache;
    private boolean idParamPresent;

    public DefaultJiraIssuesManager(JiraIssuesColumnManager jiraIssuesColumnManager, JiraIssuesUrlManager jiraIssuesUrlManager, RequestFactory<?> requestFactory, OutboundWhitelist outboundWhitelist, JiraService jiraService) {
        this.jiraIssuesColumnManager = jiraIssuesColumnManager;
        this.jiraIssuesUrlManager = jiraIssuesUrlManager;
        this.requestFactory = requestFactory;
        this.outboundWhitelist = outboundWhitelist;
        this.jiraService = jiraService;
    }

    @Override
    public Map<String, String> getColumnMap(String jiraIssuesUrl) {
        return this.jiraIssuesColumnManager.getColumnMap(this.jiraIssuesUrlManager.getRequestUrl(jiraIssuesUrl));
    }

    @Override
    public void setColumnMap(String jiraIssuesUrl, Map<String, String> columnMap) {
        this.jiraIssuesColumnManager.setColumnMap(this.jiraIssuesUrlManager.getRequestUrl(jiraIssuesUrl), columnMap);
    }

    protected JiraResponseHandler retrieveXML(String url, Set<String> columns, ReadOnlyApplicationLink appLink, boolean forceAnonymous, boolean isAnonymous, JiraResponseHandler.HandlerType handlerType, boolean checkCacheBeforeLookup) throws IOException, CredentialsRequiredException, ResponseException {
        return this.retrieveXMLResponse(url, columns, appLink, forceAnonymous, isAnonymous, handlerType);
    }

    protected JiraResponseHandler retrieveXML(String url, Set<String> columns, ReadOnlyApplicationLink appLink, boolean forceAnonymous, boolean isAnonymous, JiraResponseHandler.HandlerType handlerType, boolean checkCacheBeforeLookup, boolean updateCacheAfterLookup) throws IOException, CredentialsRequiredException, ResponseException {
        return this.retrieveXMLResponse(url, columns, appLink, forceAnonymous, isAnonymous, handlerType);
    }

    private JiraResponseHandler retrieveXMLResponse(String url, Set<String> columns, ReadOnlyApplicationLink appLink, boolean forceAnonymous, boolean isAnonymous, JiraResponseHandler.HandlerType handlerType) throws IOException, CredentialsRequiredException, ResponseException {
        String absoluteUrl;
        String finalUrl = this.getFieldRestrictedUrl(columns, url);
        if (appLink != null && !forceAnonymous) {
            ApplicationLinkRequestFactory requestFactory = this.createRequestFactory(appLink, isAnonymous);
            ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, finalUrl);
            request.setConnectionTimeout(CONNECTION_TIMEOUT);
            try {
                JiraAppLinkResponseHandler jiraApplinkResponseHandler = new JiraAppLinkResponseHandler(handlerType, url, (AuthorisationURIGenerator)requestFactory);
                request.execute((ApplicationLinkResponseHandler)jiraApplinkResponseHandler);
                return jiraApplinkResponseHandler.getResponseHandler();
            }
            catch (ResponseException e) {
                Throwable t = e.getCause();
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (t instanceof CredentialsRequiredException) {
                    throw (CredentialsRequiredException)t;
                }
                throw e;
            }
        }
        boolean isRelativeUrl = !finalUrl.startsWith("http");
        boolean isValidAppLink = appLink != null;
        String string = absoluteUrl = isRelativeUrl && isValidAppLink ? String.valueOf(appLink.getRpcUrl()) + finalUrl : finalUrl;
        if (this.outboundWhitelist.isAllowed(URI.create(absoluteUrl))) {
            Request req = this.requestFactory.createRequest(Request.MethodType.GET, absoluteUrl);
            try {
                return (JiraResponseHandler)req.executeAndReturn(resp -> {
                    try {
                        JiraUtil.checkForErrors(resp, url);
                        JiraResponseHandler responseHandler = JiraUtil.createResponseHandler(handlerType, url);
                        responseHandler.handleJiraResponse(resp.getResponseBodyAsStream());
                        return responseHandler;
                    }
                    catch (IOException ex) {
                        throw new ResponseException((Throwable)ex);
                    }
                });
            }
            catch (ResponseException ex) {
                Throwables.propagateIfPossible((Throwable)ex.getCause(), IOException.class);
                throw ex;
            }
        }
        throw new NotAuthorizedException(absoluteUrl);
    }

    protected ApplicationLinkRequestFactory createRequestFactory(ReadOnlyApplicationLink applicationLink, boolean isAnonymous) {
        if (isAnonymous) {
            return applicationLink.createAuthenticatedRequestFactory(Anonymous.class);
        }
        return applicationLink.createAuthenticatedRequestFactory();
    }

    public String getFieldRestrictedUrl(Set<String> columns, String url) {
        StringBuilder urlBuffer = new StringBuilder(url);
        boolean queryAllCustom = false;
        for (String column : columns) {
            if (this.isIdParamPresent()) {
                urlBuffer.append("&field=").append(JiraUtil.utf8Encode(column));
                continue;
            }
            String key = this.jiraIssuesColumnManager.getCanonicalFormOfBuiltInField(column);
            if (key.equals("key")) continue;
            if (key.equalsIgnoreCase("fixversion")) {
                urlBuffer.append("&field=").append("fixVersions");
                continue;
            }
            if (!this.jiraIssuesColumnManager.isColumnBuiltIn(key) && !queryAllCustom) {
                urlBuffer.append("&field=allcustom");
                queryAllCustom = true;
            }
            urlBuffer.append("&field=").append(JiraUtil.utf8Encode(key));
        }
        urlBuffer.append("&field=link");
        urlBuffer.append("&field=type");
        String urlAppended = urlBuffer.toString();
        LOGGER.debug("Jira issues request url is: {}", (Object)urlAppended);
        return urlAppended;
    }

    @Override
    public Channel retrieveXMLAsChannel(String url, Set<String> columns, ReadOnlyApplicationLink applink, boolean forceAnonymous, boolean checkCacheBeforeLookup) throws IOException, CredentialsRequiredException, ResponseException {
        JiraChannelResponseHandler handler = (JiraChannelResponseHandler)this.retrieveXML(url, columns, applink, forceAnonymous, false, JiraResponseHandler.HandlerType.CHANNEL_HANDLER, checkCacheBeforeLookup);
        return handler.getResponseChannel();
    }

    @Override
    public Channel retrieveXMLAsChannel(String url, Set<String> columns, ReadOnlyApplicationLink applink, boolean forceAnonymous, boolean checkCacheBeforeLookup, boolean updateCacheAfterLookup) throws IOException, CredentialsRequiredException, ResponseException {
        JiraChannelResponseHandler handler = (JiraChannelResponseHandler)this.retrieveXML(url, columns, applink, forceAnonymous, false, JiraResponseHandler.HandlerType.CHANNEL_HANDLER, checkCacheBeforeLookup, updateCacheAfterLookup);
        return handler.getResponseChannel();
    }

    @Override
    public Channel retrieveXMLAsChannelByAnonymous(String url, Set<String> columns, ReadOnlyApplicationLink applink, boolean forceAnonymous, boolean checkCacheBeforeLookup) throws IOException, CredentialsRequiredException, ResponseException {
        JiraChannelResponseHandler handler = (JiraChannelResponseHandler)this.retrieveXML(url, columns, applink, forceAnonymous, true, JiraResponseHandler.HandlerType.CHANNEL_HANDLER, checkCacheBeforeLookup);
        return handler.getResponseChannel();
    }

    @Override
    public Channel retrieveXMLAsChannelByAnonymous(String url, Set<String> columns, ReadOnlyApplicationLink applink, boolean forceAnonymous, boolean checkCacheBeforeLookup, boolean updateCacheAfterLookup) throws IOException, CredentialsRequiredException, ResponseException {
        JiraChannelResponseHandler handler = (JiraChannelResponseHandler)this.retrieveXML(url, columns, applink, forceAnonymous, true, JiraResponseHandler.HandlerType.CHANNEL_HANDLER, checkCacheBeforeLookup, updateCacheAfterLookup);
        return handler.getResponseChannel();
    }

    @Override
    public String retrieveXMLAsString(String url, Set<String> columns, ReadOnlyApplicationLink applink, boolean forceAnonymous, boolean checkCacheBeforeLookup) throws IOException, CredentialsRequiredException, ResponseException {
        JiraStringResponseHandler handler = (JiraStringResponseHandler)this.retrieveXML(url, columns, applink, forceAnonymous, false, JiraResponseHandler.HandlerType.STRING_HANDLER, checkCacheBeforeLookup);
        return handler.getResponseBody();
    }

    @Override
    public String retrieveXMLAsString(String url, Set<String> columns, ReadOnlyApplicationLink applink, boolean forceAnonymous, boolean checkCacheBeforeLookup, boolean updateCacheAfterLookup) throws IOException, CredentialsRequiredException, ResponseException {
        JiraStringResponseHandler handler = (JiraStringResponseHandler)this.retrieveXML(url, columns, applink, forceAnonymous, false, JiraResponseHandler.HandlerType.STRING_HANDLER, checkCacheBeforeLookup, updateCacheAfterLookup);
        return handler.getResponseBody();
    }

    @Override
    public String retrieveJQLFromFilter(String filterId, ReadOnlyApplicationLink appLink) throws ResponseException {
        JsonObject jsonObject;
        String url = String.valueOf(appLink.getRpcUrl()) + "/rest/api/2/filter/" + filterId;
        try {
            ApplicationLinkRequestFactory requestFactory = appLink.createAuthenticatedRequestFactory();
            ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, url);
            jsonObject = JsonParser.parseString((String)request.execute()).getAsJsonObject();
        }
        catch (CredentialsRequiredException e) {
            jsonObject = this.retrieveFilerByAnonymous(appLink, url);
        }
        catch (Exception e) {
            throw new ResponseException((Throwable)e);
        }
        return jsonObject.get("jql").getAsString();
    }

    @Override
    public String executeJqlQuery(String jqlQuery, ReadOnlyApplicationLink applicationLink) throws CredentialsRequiredException, ResponseException {
        String restUrl;
        ApplicationId applicationId = applicationLink.getId();
        if (this.jiraService.isJiraCloudAppLink(applicationLink.getId())) {
            DefaultJiraIssuesManager.logTraceJSISUsage(applicationId);
            restUrl = "/rest/api/2/search/jql?" + jqlQuery + "&fields=key";
        } else {
            restUrl = "/rest/api/2/search?" + jqlQuery;
        }
        ApplicationLinkRequestFactory applicationLinkRequestFactory = applicationLink.createAuthenticatedRequestFactory();
        ApplicationLinkRequest applicationLinkRequest = applicationLinkRequestFactory.createRequest(Request.MethodType.GET, restUrl);
        return (String)applicationLinkRequest.executeAndReturn(Response::getResponseBodyAsString);
    }

    private JsonObject retrieveFilerByAnonymous(ReadOnlyApplicationLink appLink, String url) throws ResponseException {
        try {
            ApplicationLinkRequestFactory requestFactory = appLink.createAuthenticatedRequestFactory(Anonymous.class);
            ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, url);
            return JsonParser.parseString((String)request.execute()).getAsJsonObject();
        }
        catch (Exception e) {
            throw new ResponseException((Throwable)e);
        }
    }

    @Override
    public List<JiraIssueBean> createIssues(List<JiraIssueBean> jiraIssueBeans, ReadOnlyApplicationLink appLink) throws CredentialsRequiredException, ResponseException {
        if (jiraIssueBeans == null || jiraIssueBeans.isEmpty()) {
            throw new IllegalArgumentException("List of Jira issues cannot be empty");
        }
        if (jiraIssueBeans.size() > 1 && this.isSupportBatchIssue(appLink).booleanValue()) {
            return this.createIssuesInBatch(jiraIssueBeans, appLink);
        }
        return this.createIssuesInSingle(jiraIssueBeans, appLink);
    }

    private List<JiraIssueBean> createIssuesInSingle(List<JiraIssueBean> jiraIssueBeans, ReadOnlyApplicationLink appLink) throws CredentialsRequiredException, ResponseException {
        ApplicationLinkRequest request = this.createRequest(appLink, Request.MethodType.POST, CREATE_JIRA_ISSUE_URL);
        request.addHeader("Content-Type", "application/json");
        for (JiraIssueBean jiraIssueBean : jiraIssueBeans) {
            this.createAndUpdateResultForJiraIssue(request, jiraIssueBean);
        }
        return jiraIssueBeans;
    }

    private List<JiraIssueBean> createIssuesInBatch(List<JiraIssueBean> jiraIssueBeans, ReadOnlyApplicationLink appLink) throws CredentialsRequiredException, ResponseException {
        ApplicationLinkRequest applinkRequest = this.createRequest(appLink, Request.MethodType.POST, CREATE_JIRA_ISSUE_BATCH_URL);
        applinkRequest.addHeader("Content-Type", "application/json");
        JsonArray jsonIssues = new JsonArray();
        for (JiraIssueBean jiraIssueBean : jiraIssueBeans) {
            String jiraIssueJson = JiraUtil.createJsonStringForJiraIssueBean(jiraIssueBean);
            JsonObject jsonObject = JsonParser.parseString((String)jiraIssueJson).getAsJsonObject();
            jsonIssues.add((JsonElement)jsonObject);
        }
        JsonObject rootIssueJson = new JsonObject();
        rootIssueJson.add("issueUpdates", (JsonElement)jsonIssues);
        applinkRequest.setRequestBody(rootIssueJson.toString());
        String jiraIssueResponseString = this.executeApplinkRequest(applinkRequest);
        this.updateResultForJiraIssueInBatch(jiraIssueBeans, jiraIssueResponseString);
        return jiraIssueBeans;
    }

    private ApplicationLinkRequest createRequest(ReadOnlyApplicationLink appLink, Request.MethodType methodType, String baseRestUrl) throws CredentialsRequiredException {
        ApplicationLinkRequest request;
        String url = String.valueOf(appLink.getRpcUrl()) + baseRestUrl;
        ApplicationLinkRequestFactory requestFactory = appLink.createAuthenticatedRequestFactory();
        try {
            request = requestFactory.createRequest(methodType, url);
        }
        catch (CredentialsRequiredException e) {
            requestFactory = appLink.createAuthenticatedRequestFactory(Anonymous.class);
            request = requestFactory.createRequest(methodType, url);
        }
        return request;
    }

    private String executeApplinkRequest(ApplicationLinkRequest appLinkRequest) throws ResponseException {
        return (String)appLinkRequest.executeAndReturn(response -> {
            if (response.isSuccessful() || response.getStatusCode() == 400) {
                return response.getResponseBodyAsString();
            }
            throw new ResponseException(String.format("Execute applink with error! [statusCode=%s, statusText=%s]", response.getStatusCode(), response.getStatusText()));
        });
    }

    private Boolean isCreateIssueBatchUrlAvailable(ReadOnlyApplicationLink appLink) throws CredentialsRequiredException {
        ApplicationLinkRequest applinkRequest = this.createRequest(appLink, Request.MethodType.GET, CREATE_JIRA_ISSUE_BATCH_URL);
        try {
            return (Boolean)applinkRequest.executeAndReturn(response -> response.getStatusCode() == 405 || response.isSuccessful());
        }
        catch (ResponseException e) {
            return false;
        }
    }

    private void updateResultForJiraIssueInBatch(List<JiraIssueBean> jiraIssueBeansInput, String jiraIssueResponseString) throws ResponseException {
        JsonObject returnIssuesJson = JsonParser.parseString((String)jiraIssueResponseString).getAsJsonObject();
        JsonArray errorsJson = returnIssuesJson.getAsJsonArray("errors");
        for (JsonElement errorElement : errorsJson) {
            JsonObject errorObj = errorElement.getAsJsonObject();
            int errorAt = errorObj.get("failedElementNumber").getAsInt();
            Map<String, String> errorMessages = this.parseErrorMessages(errorObj.getAsJsonObject("elementErrors").getAsJsonObject("errors"));
            jiraIssueBeansInput.get(errorAt).setErrors(errorMessages);
        }
        JsonArray issuesJson = returnIssuesJson.getAsJsonArray("issues");
        int successItemIndex = 0;
        for (JiraIssueBean jiraIssueBean : jiraIssueBeansInput) {
            if (jiraIssueBean.getErrors() != null && !jiraIssueBean.getErrors().isEmpty()) continue;
            String jsonIssueString = issuesJson.get(successItemIndex++).toString();
            try {
                BasicJiraIssueBean basicJiraIssueBeanReponse = JiraUtil.createBasicJiraIssueBeanFromResponse(jsonIssueString);
                JiraUtil.updateJiraIssue(jiraIssueBean, basicJiraIssueBeanReponse);
            }
            catch (IOException e) {
                throw new ResponseException("There is a problem processing the response from Jira: unrecognisable response:" + jsonIssueString, (Throwable)e);
            }
        }
    }

    private void createAndUpdateResultForJiraIssue(ApplicationLinkRequest applinkRequest, JiraIssueBean jiraIssueBean) throws ResponseException {
        String jiraIssueJson = JiraUtil.createJsonStringForJiraIssueBean(jiraIssueBean);
        applinkRequest.setRequestBody(jiraIssueJson);
        String jiraIssueResponseString = this.executeApplinkRequest(applinkRequest);
        JsonObject returnIssueJson = JsonParser.parseString((String)jiraIssueResponseString).getAsJsonObject();
        if (returnIssueJson.has("errors")) {
            jiraIssueBean.setErrors(this.parseErrorMessages(returnIssueJson.getAsJsonObject("errors")));
        } else {
            try {
                BasicJiraIssueBean basicJiraIssueBeanReponse = JiraUtil.createBasicJiraIssueBeanFromResponse(jiraIssueResponseString);
                JiraUtil.updateJiraIssue(jiraIssueBean, basicJiraIssueBeanReponse);
            }
            catch (IOException e) {
                throw new ResponseException("There is a problem processing the response from Jira: unrecognisable response:" + String.valueOf(returnIssueJson), (Throwable)e);
            }
        }
    }

    private Map<String, String> parseErrorMessages(JsonObject jsonError) {
        HashMap errors = Maps.newHashMap();
        for (Map.Entry errorEntry : jsonError.entrySet()) {
            String field = (String)errorEntry.getKey();
            String errorMessage = ((JsonElement)errorEntry.getValue()).getAsString();
            errors.put(field, errorMessage);
        }
        return errors;
    }

    protected Boolean isSupportBatchIssue(ReadOnlyApplicationLink appLink) {
        return (Boolean)this.getBatchIssueCapableCache().getUnchecked((Object)appLink);
    }

    private LoadingCache<ReadOnlyApplicationLink, Boolean> getBatchIssueCapableCache() {
        if (this.batchIssueCapableCache == null) {
            this.batchIssueCapableCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).build((CacheLoader)new CacheLoader<ReadOnlyApplicationLink, Boolean>(){

                public Boolean load(ReadOnlyApplicationLink appLink) {
                    try {
                        return DefaultJiraIssuesManager.this.isCreateIssueBatchUrlAvailable(appLink);
                    }
                    catch (CredentialsRequiredException e) {
                        return false;
                    }
                }
            });
        }
        return this.batchIssueCapableCache;
    }

    @Override
    public void setIdParamPresent(boolean idParamPresent) {
        this.idParamPresent = idParamPresent;
    }

    @Override
    public boolean isIdParamPresent() {
        return this.idParamPresent;
    }

    private static void logTraceJSISUsage(ApplicationId applicationId) {
        LOGGER.trace("Using '{}' JSIS endpoint for Jira Cloud appId as '{}' JVIS one is deprecated: {}", new Object[]{REST_JQL_JSIS_CLOUD_PATH, REST_JQL_JVIS_DC_PATH, applicationId});
    }
}

