/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.jira.request;

import com.atlassian.confluence.extra.jira.Channel;
import com.atlassian.confluence.extra.jira.api.services.JiraResponseHandler;
import com.atlassian.confluence.extra.jira.request.SAXBuilderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraChannelResponseHandler
implements JiraResponseHandler,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(JiraChannelResponseHandler.class);
    private final String url;
    private Channel responseChannel;

    public JiraChannelResponseHandler(String url) {
        this.url = url;
    }

    public Channel getResponseChannel() {
        return this.responseChannel;
    }

    @Override
    public void handleJiraResponse(InputStream in) throws IOException {
        this.responseChannel = new Channel(this.url, IOUtils.toByteArray((InputStream)in));
    }

    public static Element getChannelElement(InputStream responseStream) throws IOException {
        try {
            SAXBuilder saxBuilder = SAXBuilderFactory.createSAXBuilder();
            Document document = saxBuilder.build(responseStream);
            Element root = document.getRootElement();
            if (root != null) {
                Element element = root.getChild("channel");
                return element;
            }
            Element element = null;
            return element;
        }
        catch (JDOMException e) {
            log.error("Error while trying to assemble the issues returned in XML format: {}", (Object)e.getMessage());
            throw new IOException(e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((InputStream)responseStream);
        }
    }
}

