/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.jira.util;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.ReadOnlyApplicationLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.auth.Anonymous;
import com.atlassian.applinks.api.auth.types.OAuthAuthenticationProvider;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.integration.jira.JiraAuthenticationRequiredException;
import com.atlassian.sal.api.net.Request;

public class JiraConnectorUtils {
    private JiraConnectorUtils() {
    }

    public static ApplicationLinkRequest getApplicationLinkRequest(ReadOnlyApplicationLink applicationLink, Request.MethodType methodType, String url) throws CredentialsRequiredException {
        ApplicationLinkRequest applicationLinkRequest;
        try {
            ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory();
            applicationLinkRequest = requestFactory.createRequest(methodType, url);
        }
        catch (CredentialsRequiredException e) {
            ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory(Anonymous.class);
            applicationLinkRequest = requestFactory.createRequest(methodType, url);
        }
        return applicationLinkRequest;
    }

    public static Object[] getApplicationLinkRequestWithOauUrl(ReadOnlyApplicationLink applicationLink, Request.MethodType methodType, String url) throws CredentialsRequiredException {
        ApplicationLinkRequest applicationLinkRequest;
        String oauUrl = null;
        try {
            ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory();
            applicationLinkRequest = requestFactory.createRequest(methodType, url);
        }
        catch (CredentialsRequiredException e) {
            oauUrl = JiraConnectorUtils.getAuthUrlFromException((Exception)((Object)e));
            ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory(Anonymous.class);
            applicationLinkRequest = requestFactory.createRequest(methodType, url);
        }
        return new Object[]{applicationLinkRequest, oauUrl};
    }

    public static String getAuthUrl(AuthenticationConfigurationManager authenticationConfigurationManager, ReadOnlyApplicationLink applicationLink) {
        if (authenticationConfigurationManager.isConfigured(applicationLink.getId(), OAuthAuthenticationProvider.class)) {
            try {
                applicationLink.createAuthenticatedRequestFactory().createRequest(Request.MethodType.GET, "");
            }
            catch (CredentialsRequiredException e) {
                return JiraConnectorUtils.getAuthUrlFromException((Exception)((Object)e));
            }
        }
        return null;
    }

    public static ReadOnlyApplicationLink getApplicationLink(ReadOnlyApplicationLinkService applicationLinkService, String appId) throws TypeNotInstalledException {
        ReadOnlyApplicationLink applicationLink = applicationLinkService.getApplicationLink(new ApplicationId(appId));
        if (applicationLink == null) {
            throw new TypeNotInstalledException("Can not get Application Link", null, null);
        }
        return applicationLink;
    }

    public static String getAuthUrlFromException(Exception exception) {
        if (exception instanceof CredentialsRequiredException) {
            CredentialsRequiredException e = (CredentialsRequiredException)((Object)exception);
            return e.getAuthorisationURI().toString();
        }
        if (exception instanceof JiraAuthenticationRequiredException) {
            JiraAuthenticationRequiredException e = (JiraAuthenticationRequiredException)exception;
            return e.getAuthenticationUri().toString();
        }
        return null;
    }
}

