/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.jira.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.ReadOnlyApplicationLinkService;
import com.atlassian.confluence.extra.jira.JiraIssuesManager;
import com.atlassian.confluence.extra.jira.util.ResponseUtil;
import com.atlassian.confluence.plugins.jira.beans.JiraIssueBean;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.sal.api.net.ResponseException;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;

@Path(value="/jira-issue")
public class CreateJiraIssueResource {
    private final ReadOnlyApplicationLinkService appLinkService;
    private final JiraIssuesManager jiraIssuesManager;
    private final PermissionManager permissionManager;

    @Inject
    public CreateJiraIssueResource(ReadOnlyApplicationLinkService appLinkService, JiraIssuesManager jiraIssuesManager, PermissionManager permissionManager) {
        this.appLinkService = appLinkService;
        this.jiraIssuesManager = jiraIssuesManager;
        this.permissionManager = permissionManager;
    }

    @POST
    @Path(value="create-jira-issues/{appLinkId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @AnonymousSiteAccess
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response createJiraIssues(@PathParam(value="appLinkId") String appLinkId, List<JiraIssueBean> jiraIssueBeans) {
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, PermissionManager.TARGET_APPLICATION)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        try {
            ReadOnlyApplicationLink appLink = this.appLinkService.getApplicationLink(new ApplicationId(appLinkId));
            List<JiraIssueBean> resultJiraIssueBeans = this.jiraIssuesManager.createIssues(jiraIssueBeans, appLink);
            Predicate jiraIssueSuccess = jiraIssueBean -> jiraIssueBean.getErrors() == null || jiraIssueBean.getErrors().isEmpty();
            if (Collections2.filter(resultJiraIssueBeans, (Predicate)jiraIssueSuccess).isEmpty()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(resultJiraIssueBeans).build();
            }
            return Response.ok(resultJiraIssueBeans).build();
        }
        catch (CredentialsRequiredException e) {
            String authorisationURI = e.getAuthorisationURI().toString();
            return ResponseUtil.buildUnauthorizedResponse(authorisationURI);
        }
        catch (ResponseException re) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)re.getMessage()).build();
        }
    }
}

