/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.jira.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.extra.jira.api.services.JiraConnectorManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="servers")
@Produces(value={"application/json"})
@AnonymousSiteAccess
public class JiraConnectorStateResource {
    private final JiraConnectorManager jiraConnectorManager;
    private final PermissionManager permissionManager;

    @Inject
    public JiraConnectorStateResource(JiraConnectorManager jiraConnectorManager, PermissionManager permissionManager) {
        this.jiraConnectorManager = jiraConnectorManager;
        this.permissionManager = permissionManager;
    }

    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Response getJiraServers() {
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, PermissionManager.TARGET_APPLICATION)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return Response.ok(this.jiraConnectorManager.getJiraServers()).build();
    }
}

