/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.jiracharts;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.ReadOnlyApplicationLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.confluence.extra.jira.api.services.JiraConnectorManager;
import com.atlassian.confluence.extra.jira.util.JiraConnectorUtils;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.plugins.jira.beans.JiraServerBean;
import com.atlassian.confluence.plugins.jiracharts.JQLValidator;
import com.atlassian.confluence.plugins.jiracharts.model.JQLValidationResult;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.web.UrlBuilder;
import com.atlassian.integration.jira.JiraAuthenticationRequiredException;
import com.atlassian.integration.jira.JiraService;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultJQLValidator
implements JQLValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJQLValidator.class);
    private static final String REST_JQL_ISSUE_SEARCH_DC_PATH = "/rest/api/2/search";
    private static final String REST_JQL_ISSUE_COUNT_CLOUD_PATH = "/rest/api/2/search/approximate-count";
    private static final String JIRA_FILTER_NAV_URL = "/secure/IssueNavigator.jspa?reset=true&mode=hide";
    private static final Long START_JIRA_UNSUPPORTED_BUILD_NUMBER = 6109L;
    private static final Long END_JIRA_UNSUPPORTED_BUILD_NUMBER = 6155L;
    private static final Logger log = LoggerFactory.getLogger(DefaultJQLValidator.class);
    private final ReadOnlyApplicationLinkService applicationLinkService;
    private final I18nResolver i18nResolver;
    private final JiraConnectorManager jiraConnectorManager;
    private final JiraService jiraService;

    public DefaultJQLValidator(ReadOnlyApplicationLinkService applicationLinkService, I18nResolver i18nResolver, JiraConnectorManager jiraConnectorManager, JiraService jiraService) {
        this.applicationLinkService = applicationLinkService;
        this.jiraConnectorManager = jiraConnectorManager;
        this.i18nResolver = i18nResolver;
        this.jiraService = jiraService;
    }

    @Override
    public JQLValidationResult doValidate(Map<String, String> parameters, boolean isVerifyChartSupported) throws MacroExecutionException {
        try {
            String jql = HtmlUtil.urlDecode((String)parameters.get("jql"), (Charset)GeneralUtil.getDefaultCharset());
            String appLinkId = parameters.get("serverId");
            ReadOnlyApplicationLink applicationLink = JiraConnectorUtils.getApplicationLink(this.applicationLinkService, appLinkId);
            if (isVerifyChartSupported) {
                this.validateJiraSupportedVersion(applicationLink);
            }
            return this.validateJQL(applicationLink, jql);
        }
        catch (TypeNotInstalledException e) {
            log.debug("AppLink is not exits", (Throwable)e);
            throw new MacroExecutionException(this.i18nResolver.getText("jirachart.error.applicationLinkNotExist"));
        }
    }

    private JQLValidationResult validateJQL(ReadOnlyApplicationLink applicationLink, String jql) throws MacroExecutionException {
        JQLValidationResult result = new JQLValidationResult();
        try {
            this.validateInternal(applicationLink, jql, result);
            String displayUrl = applicationLink.getDisplayUrl().toString();
            String rpcUrl = applicationLink.getRpcUrl().toString();
            UrlBuilder builder = new UrlBuilder(displayUrl + JIRA_FILTER_NAV_URL);
            builder.add("jqlQuery", jql);
            result.setFilterUrl(builder.toUrl());
            result.setDisplayUrl(displayUrl);
            result.setRpcUrl(rpcUrl);
        }
        catch (Exception e) {
            log.debug("Exception during make a call to Jira via Applink", (Throwable)e);
            throw new MacroExecutionException((Throwable)e);
        }
        return result;
    }

    private void validateJiraSupportedVersion(ReadOnlyApplicationLink appLinkId) throws MacroExecutionException {
        JiraServerBean jiraServerBean = this.jiraConnectorManager.getJiraServer(appLinkId);
        if (jiraServerBean != null) {
            Long buildNumber = jiraServerBean.getBuildNumber();
            if (buildNumber == -1L) {
                throw new MacroExecutionException(this.i18nResolver.getText("jirachart.error.cannot.call.jira"));
            }
            if (buildNumber >= START_JIRA_UNSUPPORTED_BUILD_NUMBER && buildNumber < END_JIRA_UNSUPPORTED_BUILD_NUMBER) {
                throw new MacroExecutionException(this.i18nResolver.getText("jirachart.version.unsupported"));
            }
        }
    }

    private void validateInternal(ReadOnlyApplicationLink applicationLink, String jql, JQLValidationResult result) throws CredentialsRequiredException, ResponseException {
        try {
            JQLApplicationLinkResponseHandler handler;
            Object[] objects;
            ApplicationId applicationId = applicationLink.getId();
            if (this.jiraService.isJiraCloudAppLink(applicationId)) {
                objects = this.oauthRequestOfIssueCountForCloud(applicationLink, jql);
                handler = new JQLIssueCountCloudApplicationLinkResponseHandler();
            } else {
                objects = this.oauthRequestOfIssueSearchForDC(applicationLink, jql);
                handler = new JQLApplicationLinkResponseHandler();
            }
            JiraResponse jiraResponse = (JiraResponse)((ApplicationLinkRequest)objects[0]).execute((ApplicationLinkResponseHandler)handler);
            if (objects[1] != null) {
                result.setAuthUrl((String)objects[1]);
            }
            result.setErrorMgs(jiraResponse.getErrors());
            result.setIssueCount(jiraResponse.getIssueCount());
        }
        catch (JiraAuthenticationRequiredException e) {
            result.setAuthUrl(JiraConnectorUtils.getAuthUrlFromException((Exception)((Object)e)));
        }
    }

    private Object[] oauthRequestOfIssueCountForCloud(ReadOnlyApplicationLink applicationLink, String jql) throws CredentialsRequiredException {
        DefaultJQLValidator.logTraceJSISUsage(applicationLink.getId());
        UrlBuilder urlBuilder = new UrlBuilder(REST_JQL_ISSUE_COUNT_CLOUD_PATH);
        Object[] objects = JiraConnectorUtils.getApplicationLinkRequestWithOauUrl(applicationLink, Request.MethodType.POST, urlBuilder.toUrl());
        ApplicationLinkRequest applicationLinkRequest = (ApplicationLinkRequest)objects[0];
        applicationLinkRequest.setRequestBody(new JSONObject(Map.of("jql", jql)).toString(), "application/json");
        return objects;
    }

    private Object[] oauthRequestOfIssueSearchForDC(ReadOnlyApplicationLink applicationLink, String jql) throws CredentialsRequiredException {
        UrlBuilder urlBuilder = new UrlBuilder(REST_JQL_ISSUE_SEARCH_DC_PATH);
        urlBuilder.add("jql", jql).add("maxResults", 0);
        return JiraConnectorUtils.getApplicationLinkRequestWithOauUrl(applicationLink, Request.MethodType.GET, urlBuilder.toUrl());
    }

    private static void logTraceJSISUsage(ApplicationId applicationId) {
        LOGGER.trace("Using '{}' endpoint to count issue for Jira Cloud appId as '{}' JVIS one is deprecated: {}", new Object[]{REST_JQL_ISSUE_COUNT_CLOUD_PATH, REST_JQL_ISSUE_SEARCH_DC_PATH, applicationId});
    }

    private class JQLIssueCountCloudApplicationLinkResponseHandler
    extends JQLApplicationLinkResponseHandler {
        private JQLIssueCountCloudApplicationLinkResponseHandler() {
        }

        @Override
        protected String getCountAttributeName() {
            return "count";
        }
    }

    private class JQLApplicationLinkResponseHandler
    implements ApplicationLinkResponseHandler<JiraResponse> {
        private JQLApplicationLinkResponseHandler() {
        }

        public JiraResponse handle(Response response) throws ResponseException {
            JiraResponse returnValue = new JiraResponse();
            int responseStatus = response.getStatusCode();
            String responseBody = response.getResponseBodyAsString();
            try {
                JSONObject json = new JSONObject(responseBody);
                if (responseStatus >= 400) {
                    JSONArray errorsArray = json.getJSONArray("errorMessages");
                    List<String> errorsList = errorsArray.toList().stream().map(Object::toString).collect(Collectors.toList());
                    returnValue.setErrors(errorsList);
                }
                if (responseStatus == 200) {
                    returnValue.setIssueCount(json.getInt(this.getCountAttributeName()));
                }
            }
            catch (JSONException ex) {
                throw new ResponseException("Could not parse json from Jira", (Throwable)ex);
            }
            return returnValue;
        }

        public JiraResponse credentialsRequired(Response paramResponse) {
            return null;
        }

        protected String getCountAttributeName() {
            return "total";
        }
    }

    private class JiraResponse {
        private List<String> errors;
        private int issueCount;

        private JiraResponse() {
        }

        public List<String> getErrors() {
            return this.errors;
        }

        public void setErrors(List<String> errors) {
            this.errors = errors;
        }

        public int getIssueCount() {
            return this.issueCount;
        }

        public void setIssueCount(int issueCount) {
            this.issueCount = issueCount;
        }
    }
}

