/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert;

import java.io.IOException;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.DeltaCertificateDescriptor;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.asn1.x509.Validity;
import org.bouncycastle.cert.X509CertificateHolder;

public class DeltaCertificateTool {
    public static Extension makeDeltaCertificateExtension(boolean isCritical, Certificate deltaCert) throws IOException {
        DeltaCertificateDescriptor descriptor = new DeltaCertificateDescriptor(deltaCert.getSerialNumber(), deltaCert.getSignatureAlgorithm(), deltaCert.getIssuer(), deltaCert.getValidity(), deltaCert.getSubject(), deltaCert.getSubjectPublicKeyInfo(), deltaCert.getExtensions(), deltaCert.getSignature());
        DEROctetString extnValue = new DEROctetString(descriptor.getEncoded("DER"));
        return new Extension(Extension.deltaCertificateDescriptor, isCritical, (ASN1OctetString)extnValue);
    }

    public static Extension makeDeltaCertificateExtension(boolean isCritical, X509CertificateHolder deltaCert) throws IOException {
        return DeltaCertificateTool.makeDeltaCertificateExtension(isCritical, deltaCert.toASN1Structure());
    }

    public static Certificate extractDeltaCertificate(TBSCertificate baseTBSCert) {
        X500Name subject;
        Validity validity;
        X500Name issuer;
        Extensions baseExtensions = baseTBSCert.getExtensions();
        Extension dcdExtension = baseExtensions.getExtension(Extension.deltaCertificateDescriptor);
        if (dcdExtension == null) {
            throw new IllegalStateException("no deltaCertificateDescriptor present");
        }
        DeltaCertificateDescriptor descriptor = DeltaCertificateDescriptor.getInstance((Object)dcdExtension.getParsedValue());
        ASN1Integer version = baseTBSCert.getVersion();
        ASN1Integer serialNumber = descriptor.getSerialNumber();
        AlgorithmIdentifier signature = descriptor.getSignature();
        if (signature == null) {
            signature = baseTBSCert.getSignature();
        }
        if ((issuer = descriptor.getIssuer()) == null) {
            issuer = baseTBSCert.getIssuer();
        }
        if ((validity = descriptor.getValidityObject()) == null) {
            validity = baseTBSCert.getValidity();
        }
        if ((subject = descriptor.getSubject()) == null) {
            subject = baseTBSCert.getSubject();
        }
        SubjectPublicKeyInfo subjectPublicKeyInfo = descriptor.getSubjectPublicKeyInfo();
        Extensions extensions = DeltaCertificateTool.extractDeltaExtensions(descriptor.getExtensions(), baseExtensions);
        TBSCertificate tbsCertificate = new TBSCertificate(version, serialNumber, signature, issuer, validity, subject, subjectPublicKeyInfo, null, null, extensions);
        return new Certificate(tbsCertificate, signature, descriptor.getSignatureValue());
    }

    public static X509CertificateHolder extractDeltaCertificate(X509CertificateHolder baseCert) {
        return new X509CertificateHolder(DeltaCertificateTool.extractDeltaCertificate(baseCert.getTBSCertificate()));
    }

    public static DeltaCertificateDescriptor trimDeltaCertificateDescriptor(DeltaCertificateDescriptor descriptor, TBSCertificate tbsCertificate, Extensions tbsExtensions) {
        return descriptor.trimTo(tbsCertificate, tbsExtensions);
    }

    private static Extensions extractDeltaExtensions(Extensions descriptorExtensions, Extensions baseExtensions) {
        ExtensionsGenerator extGen = new ExtensionsGenerator();
        Enumeration baseEnum = baseExtensions.oids();
        while (baseEnum.hasMoreElements()) {
            ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)baseEnum.nextElement();
            if (Extension.deltaCertificateDescriptor.equals((ASN1Primitive)oid)) continue;
            extGen.addExtension(baseExtensions.getExtension(oid));
        }
        if (descriptorExtensions != null) {
            Enumeration descriptorEnum = descriptorExtensions.oids();
            while (descriptorEnum.hasMoreElements()) {
                ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)descriptorEnum.nextElement();
                extGen.replaceExtension(descriptorExtensions.getExtension(oid));
            }
        }
        return extGen.isEmpty() ? null : extGen.generate();
    }
}

