/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pkcs.bc;

import java.io.OutputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PBMAC1Params;
import org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.RC2Engine;
import org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.io.MacOutputStream;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.DESedeParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.operator.GenericKey;
import org.bouncycastle.operator.MacCalculator;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Strings;

class PKCS12PBEUtils {
    private static Map keySizes = new HashMap();
    private static Set noIvAlgs = new HashSet();
    private static Set desAlgs = new HashSet();

    PKCS12PBEUtils() {
    }

    static int getKeySize(ASN1ObjectIdentifier algorithm) {
        return (Integer)keySizes.get(algorithm);
    }

    static boolean hasNoIv(ASN1ObjectIdentifier algorithm) {
        return noIvAlgs.contains(algorithm);
    }

    static boolean isDesAlg(ASN1ObjectIdentifier algorithm) {
        return desAlgs.contains(algorithm);
    }

    static PaddedBufferedBlockCipher getEngine(ASN1ObjectIdentifier algorithm) {
        DESedeEngine engine;
        if (algorithm.equals((ASN1Primitive)PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC) || algorithm.equals((ASN1Primitive)PKCSObjectIdentifiers.pbeWithSHAAnd2_KeyTripleDES_CBC)) {
            engine = new DESedeEngine();
        } else if (algorithm.equals((ASN1Primitive)PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC2_CBC) || algorithm.equals((ASN1Primitive)PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC)) {
            engine = new RC2Engine();
        } else {
            throw new IllegalStateException("unknown algorithm");
        }
        return new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)engine), (BlockCipherPadding)new PKCS7Padding());
    }

    static MacCalculator createMacCalculator(final ASN1ObjectIdentifier digestAlgorithm, ExtendedDigest digest, final PKCS12PBEParams pbeParams, final char[] password) {
        PKCS12ParametersGenerator pGen = new PKCS12ParametersGenerator((Digest)digest);
        pGen.init(PKCS12ParametersGenerator.PKCS12PasswordToBytes((char[])password), pbeParams.getIV(), pbeParams.getIterations().intValue());
        KeyParameter keyParam = (KeyParameter)pGen.generateDerivedMacParameters(digest.getDigestSize() * 8);
        final HMac hMac = new HMac((Digest)digest);
        hMac.init((CipherParameters)keyParam);
        return new MacCalculator(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return new AlgorithmIdentifier(digestAlgorithm, (ASN1Encodable)pbeParams);
            }

            @Override
            public OutputStream getOutputStream() {
                return new MacOutputStream((Mac)hMac);
            }

            @Override
            public byte[] getMac() {
                byte[] res = new byte[hMac.getMacSize()];
                hMac.doFinal(res, 0);
                return res;
            }

            @Override
            public GenericKey getKey() {
                return new GenericKey(this.getAlgorithmIdentifier(), PKCS12ParametersGenerator.PKCS12PasswordToBytes((char[])password));
            }
        };
    }

    static MacCalculator createPBMac1Calculator(final PBMAC1Params pbmac1Params, PBKDF2Params pbkdf2Params, final char[] password) {
        final HMac hMac = new HMac(PKCS12PBEUtils.getPrf(pbmac1Params.getMessageAuthScheme().getAlgorithm()));
        PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator(PKCS12PBEUtils.getPrf(pbkdf2Params.getPrf().getAlgorithm()));
        generator.init(Strings.toUTF8ByteArray((char[])password), pbkdf2Params.getSalt(), BigIntegers.intValueExact((BigInteger)pbkdf2Params.getIterationCount()));
        CipherParameters key = generator.generateDerivedParameters(BigIntegers.intValueExact((BigInteger)pbkdf2Params.getKeyLength()) * 8);
        hMac.init(key);
        return new MacCalculator(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBMAC1, (ASN1Encodable)pbmac1Params);
            }

            @Override
            public OutputStream getOutputStream() {
                return new MacOutputStream((Mac)hMac);
            }

            @Override
            public byte[] getMac() {
                byte[] res = new byte[hMac.getMacSize()];
                hMac.doFinal(res, 0);
                return res;
            }

            @Override
            public GenericKey getKey() {
                return new GenericKey(this.getAlgorithmIdentifier(), Strings.toUTF8ByteArray((char[])password));
            }
        };
    }

    private static Digest getPrf(ASN1ObjectIdentifier prfId) {
        if (PKCSObjectIdentifiers.id_hmacWithSHA256.equals((ASN1Primitive)prfId)) {
            return new SHA256Digest();
        }
        if (PKCSObjectIdentifiers.id_hmacWithSHA512.equals((ASN1Primitive)prfId)) {
            return new SHA512Digest();
        }
        throw new IllegalArgumentException("unknown prf id " + prfId);
    }

    static CipherParameters createCipherParameters(ASN1ObjectIdentifier algorithm, ExtendedDigest digest, int blockSize, PKCS12PBEParams pbeParams, char[] password) {
        CipherParameters params;
        PKCS12ParametersGenerator pGen = new PKCS12ParametersGenerator((Digest)digest);
        pGen.init(PKCS12ParametersGenerator.PKCS12PasswordToBytes((char[])password), pbeParams.getIV(), pbeParams.getIterations().intValue());
        if (PKCS12PBEUtils.hasNoIv(algorithm)) {
            params = pGen.generateDerivedParameters(PKCS12PBEUtils.getKeySize(algorithm));
        } else {
            params = pGen.generateDerivedParameters(PKCS12PBEUtils.getKeySize(algorithm), blockSize * 8);
            if (PKCS12PBEUtils.isDesAlg(algorithm)) {
                DESedeParameters.setOddParity((byte[])((KeyParameter)((ParametersWithIV)params).getParameters()).getKey());
            }
        }
        return params;
    }

    static {
        keySizes.put(PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC4, Integers.valueOf((int)128));
        keySizes.put(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC4, Integers.valueOf((int)40));
        keySizes.put(PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC, Integers.valueOf((int)192));
        keySizes.put(PKCSObjectIdentifiers.pbeWithSHAAnd2_KeyTripleDES_CBC, Integers.valueOf((int)128));
        keySizes.put(PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC2_CBC, Integers.valueOf((int)128));
        keySizes.put(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC, Integers.valueOf((int)40));
        noIvAlgs.add(PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC4);
        noIvAlgs.add(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC4);
        desAlgs.add(PKCSObjectIdentifiers.pbeWithSHAAnd2_KeyTripleDES_CBC);
        desAlgs.add(PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC);
    }
}

