/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.impl;

import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.sal.api.user.UserKey;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;

public class ConfluenceJacksonSupport
extends Module {
    public String getModuleName() {
        return "Confluence Notifications Support";
    }

    public Version version() {
        return new Version(1, 0, 0, "", "", "");
    }

    public void setupModule(Module.SetupContext context) {
        context.addDeserializers((Deserializers)new ConfluenceDeserializers());
        context.addSerializers((Serializers)new ConfluenceSerializers());
    }

    private class ConfluenceDeserializers
    extends SimpleDeserializers {
        private ConfluenceDeserializers() {
        }

        public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) {
            Class raw = type.getRawClass();
            if (UserKey.class.isAssignableFrom(raw)) {
                return new UserKeyDeserializer();
            }
            if (ContentId.class.isAssignableFrom(raw)) {
                return new ContentIdDeserializer();
            }
            return null;
        }
    }

    private class ConfluenceSerializers
    extends SimpleSerializers {
        private ConfluenceSerializers() {
        }

        public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
            Class raw = type.getRawClass();
            if (UserKey.class.isAssignableFrom(raw)) {
                return new UserKeySerializer();
            }
            if (ContentId.class.isAssignableFrom(raw)) {
                return new ContentIdSerializer();
            }
            return null;
        }
    }

    private class ContentIdSerializer
    extends StdSerializer<ContentId> {
        public ContentIdSerializer() {
            super(ContentId.class);
        }

        public void serialize(ContentId value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.serialise());
        }
    }

    private class ContentIdDeserializer
    extends StdDeserializer<ContentId> {
        public ContentIdDeserializer() {
            super(ContentId.class);
        }

        public ContentId deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            return ContentId.deserialise((String)jp.getText());
        }
    }

    private class UserKeySerializer
    extends StdSerializer<UserKey> {
        public UserKeySerializer() {
            super(UserKey.class);
        }

        public void serialize(UserKey value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.getStringValue());
        }
    }

    private class UserKeyDeserializer
    extends StdDeserializer<UserKey> {
        public UserKeyDeserializer() {
            super(UserKey.class);
        }

        public UserKey deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            return new UserKey(jp.getText());
        }
    }
}

