/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.impl;

import com.atlassian.confluence.notifications.impl.ConfluenceJacksonSupport;
import com.atlassian.confluence.notifications.impl.ObjectMapperFactory;
import com.atlassian.confluence.util.DefaultObjectMapperProvider;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Pair;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class DefaultObjectMapperFactory
implements ObjectMapperFactory {
    @Override
    public ObjectMapper buildObjectMapper() {
        ObjectMapper mapper = new DefaultObjectMapperProvider().getObjectMapper();
        mapper.setVisibilityChecker(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        mapper.registerModule((Module)new ConfluenceJacksonSupport());
        return mapper;
    }

    @Override
    public Pair<ObjectReader, ObjectWriter> buildObjectMapper(Class<?> clazz) {
        ObjectMapper mapper = this.buildObjectMapper();
        ObjectWriter writer = mapper.writerWithType(clazz);
        ObjectReader reader = mapper.reader(clazz);
        return Pair.pair((Object)reader, (Object)writer);
    }

    @Override
    public <T> Either<IllegalStateException, T> verifyObjectSerializable(T payload) {
        Pair<ObjectReader, ObjectWriter> readerWriter = this.buildObjectMapper(payload.getClass());
        StringWriter buffer = new StringWriter();
        try {
            ((ObjectWriter)readerWriter.right()).writeValue((Writer)buffer, payload);
            Object output = ((ObjectReader)readerWriter.left()).readValue(buffer.toString());
            return Either.right((Object)output);
        }
        catch (IOException e) {
            IllegalStateException exception = new IllegalStateException(String.format("Given instance of [%s] is not serializable with Jackson, see cause.", payload.getClass().getName()), e);
            return Either.left((Object)exception);
        }
    }
}

