/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.impl;

import com.atlassian.confluence.notifications.DispatchService;
import com.atlassian.confluence.notifications.Notification;
import com.atlassian.confluence.notifications.NotificationPayload;
import com.atlassian.confluence.notifications.ProductionAwareLoggerSwitch;
import com.atlassian.confluence.notifications.RecipientsProvider;
import com.atlassian.confluence.notifications.impl.NotificationDescriptorLocator;
import com.atlassian.confluence.notifications.impl.descriptors.AbstractParticipantDescriptor;
import com.atlassian.confluence.notifications.impl.descriptors.NotificationDescriptor;
import com.atlassian.plugin.notifications.api.event.NotificationEvent;
import com.atlassian.plugin.notifications.api.medium.NotificationAddress;
import com.atlassian.plugin.notifications.api.medium.recipient.RoleRecipient;
import com.atlassian.plugin.notifications.api.medium.recipient.UserKeyRoleRecipient;
import com.atlassian.plugin.notifications.api.queue.NotificationQueueManager;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Pair;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

final class NotificationQueueDispatchService
implements DispatchService {
    private static final ProductionAwareLoggerSwitch log = ProductionAwareLoggerSwitch.forClass(NotificationQueueDispatchService.class);
    private final NotificationDescriptorLocator descriptorLocator;
    private final NotificationQueueManager queueManager;
    private final TransactionTemplate transactionTemplate;

    public NotificationQueueDispatchService(NotificationDescriptorLocator descriptorLocator, NotificationQueueManager queueManager, TransactionTemplate transactionTemplate) {
        this.descriptorLocator = descriptorLocator;
        this.queueManager = queueManager;
        this.transactionTemplate = transactionTemplate;
    }

    public void dispatch(Notification notification) {
        this.dispatchWithAdditionalRecipients(notification, Collections.EMPTY_LIST);
    }

    public void dispatchWithAdditionalRecipients(Notification notification, Iterable<RoleRecipient> additionalRecipients) {
        NotificationDescriptor notificationDescriptor = (NotificationDescriptor)((Object)this.descriptorLocator.findNotificationDescriptor(notification.getPayload(), notification.getKey()).get());
        Iterable<RecipientsProvider> recipientsProviders = this.findRecipientProviders(notification);
        if (Iterables.isEmpty(recipientsProviders) && Iterables.isEmpty(additionalRecipients)) {
            log.warnOrDebug("No additional recipients were provided and no recipient providers for notification [%s] were found, thus aborting dispatch.", new Object[]{notification});
            return;
        }
        Callable<Iterable<RoleRecipient>> computeUserRecipients = () -> this.compileDistinctRecipients(Iterables.concat(this.collectUserBasedRecipients(notification, recipientsProviders), (Iterable)additionalRecipients));
        Callable<Iterable<NotificationAddress>> computeNonUserRecipients = () -> this.collectNonUserBasedRecipients(notification, recipientsProviders);
        this.dispatchForRecipients(notification, notificationDescriptor, computeUserRecipients, computeNonUserRecipients, (RecipientsProvider[])Iterables.toArray(recipientsProviders, RecipientsProvider.class));
    }

    private Iterable<NotificationAddress> collectNonUserBasedRecipients(Notification notification, Iterable<RecipientsProvider> recipientsProviders) {
        return Iterables.concat((Iterable)Iterables.transform(recipientsProviders, provider -> {
            try {
                return provider.nonUserBasedRecipientsFor(notification);
            }
            catch (RuntimeException e) {
                log.errorOrDebug((Throwable)e);
                return Collections.EMPTY_LIST;
            }
        }));
    }

    public void dispatchForExclusiveRecipients(Notification notification, Iterable<RoleRecipient> exlusiveRecipients) {
        NotificationDescriptor notificationDescriptor = (NotificationDescriptor)((Object)this.descriptorLocator.findNotificationDescriptor(notification.getPayload(), notification.getKey()).get());
        Callable<Iterable<RoleRecipient>> computeUserRecipients = () -> this.compileDistinctRecipients(exlusiveRecipients);
        Callable<Iterable<NotificationAddress>> computeNonUserRecipients = () -> Collections.EMPTY_LIST;
        this.dispatchForRecipients(notification, notificationDescriptor, computeUserRecipients, computeNonUserRecipients, new RecipientsProvider[0]);
    }

    private void dispatchForRecipients(Notification notification, NotificationDescriptor descriptor, Callable<Iterable<RoleRecipient>> computeUserRecipients, Callable<Iterable<NotificationAddress>> computeNonUserRecipients, RecipientsProvider ... recipientsProviders) {
        try {
            Pair r = (Pair)this.transactionTemplate.execute(() -> {
                try {
                    Iterable userRecipients = (Iterable)computeUserRecipients.call();
                    Iterable nonUserRecipients = (Iterable)computeNonUserRecipients.call();
                    return Pair.pair((Object)userRecipients, (Object)nonUserRecipients);
                }
                catch (Exception e) {
                    log.errorOrDebug((Throwable)e, "Error computing recipients", new Object[0]);
                    return Pair.pair(Collections.emptyList(), Collections.emptyList());
                }
            });
            Iterable userRecipients = (Iterable)r.left();
            Iterable nonUserRecipients = (Iterable)r.right();
            if (Iterables.isEmpty((Iterable)userRecipients) && Iterables.isEmpty((Iterable)nonUserRecipients)) {
                log.warnOrDebug("No recipients were compiled for notification [%s] from the following list of providers [%s], thus aborting dispatch.", new Object[]{notification, ToStringBuilder.reflectionToString((Object)recipientsProviders, (ToStringStyle)ToStringStyle.SIMPLE_STYLE)});
                return;
            }
            NotificationEvent notificationEvent = descriptor.getNotificationEventFactory().create(notification);
            if (!Iterables.isEmpty((Iterable)userRecipients)) {
                this.queueManager.submitIndividualNotification(userRecipients, notificationEvent);
            }
            if (!Iterables.isEmpty((Iterable)nonUserRecipients)) {
                this.queueManager.submitIndividualNotificationViaAddress(nonUserRecipients, notificationEvent);
            }
        }
        catch (IllegalStateException ex) {
            log.errorOrDebug((Throwable)ex, "Error submitting email for generation, check your payload class is serialisable.", new Object[0]);
        }
        catch (Exception ex) {
            log.errorOrDebug((Throwable)ex, "Error submitting email for generation", new Object[0]);
        }
    }

    private Iterable<UserKeyRoleRecipient> collectUserBasedRecipients(Notification notification, Iterable<RecipientsProvider> notificationRecipientsProviders) {
        return Iterables.concat((Iterable)Iterables.transform(notificationRecipientsProviders, provider -> {
            try {
                return provider.userBasedRecipientsFor(notification);
            }
            catch (RuntimeException e) {
                log.errorOrDebug((Throwable)e);
                return Collections.EMPTY_LIST;
            }
        }));
    }

    private <T extends RoleRecipient> Iterable<T> compileDistinctRecipients(Iterable<T> recipients) {
        Comparator<RoleRecipient> compareLexographically = Comparator.comparing(o -> o.getUserKey().getStringValue());
        return ImmutableSortedSet.copyOf(compareLexographically, (Iterable)Iterables.filter(recipients, recipient -> UserKeyRoleRecipient.UNKNOWN != recipient));
    }

    private Iterable<RecipientsProvider> findRecipientProviders(Notification notification) {
        NotificationPayload payload = notification.getPayload();
        Iterable<AbstractParticipantDescriptor<RecipientsProvider>> allRecipientProviders = this.descriptorLocator.findParticipantDescriptors(RecipientsProvider.class);
        return Iterables.filter((Iterable)Iterables.transform(allRecipientProviders, AbstractParticipantDescriptor::getModule), provider -> provider.getPayloadType().isAssignableFrom(payload.getClass()));
    }
}

