/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.impl;

import com.atlassian.confluence.core.SynchronizationManager;
import com.atlassian.confluence.notifications.DispatchService;
import com.atlassian.confluence.notifications.Notification;
import com.atlassian.confluence.notifications.ProductionAwareLoggerSwitch;
import com.atlassian.plugin.notifications.api.medium.recipient.RoleRecipient;

final class TxCommitDispatchService
implements DispatchService {
    private static final ProductionAwareLoggerSwitch log = ProductionAwareLoggerSwitch.forClass(TxCommitDispatchService.class);
    private final SynchronizationManager synchronizationManager;
    private final DispatchService delegate;

    public TxCommitDispatchService(DispatchService delegate, SynchronizationManager synchronizationManager) {
        this.synchronizationManager = synchronizationManager;
        this.delegate = delegate;
    }

    public void dispatch(Notification notification) {
        this.afterTxSubmit(notification, () -> this.delegate.dispatch(notification));
    }

    public void dispatchWithAdditionalRecipients(Notification notification, Iterable<RoleRecipient> additionalRecipients) {
        this.afterTxSubmit(notification, () -> this.delegate.dispatchWithAdditionalRecipients(notification, additionalRecipients));
    }

    public void dispatchForExclusiveRecipients(Notification notification, Iterable<RoleRecipient> exclusiveRecipients) {
        this.afterTxSubmit(notification, () -> this.delegate.dispatchForExclusiveRecipients(notification, exclusiveRecipients));
    }

    private void afterTxSubmit(Notification<?> notification, Runnable afterCommitHook) {
        if (this.synchronizationManager.isTransactionActive()) {
            log.onlyTrace("Registering transaction post-commit hook for dispatch of notification [%s]", new Object[]{notification});
            this.synchronizationManager.runOnSuccessfulCommit(afterCommitHook);
        } else {
            log.onlyTrace("No transaction active - directly dispatching notification [%s]", new Object[]{notification});
            afterCommitHook.run();
        }
    }
}

