/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.impl.descriptors;

import com.atlassian.confluence.notifications.RenderContextProvider;
import com.atlassian.confluence.notifications.impl.descriptors.AbstractParticipantDescriptor;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.internal.module.Dom4jDelegatingElement;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.notifications.api.template.TemplateDefinition;
import com.atlassian.plugin.util.validation.ValidationException;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class NotificationTemplateDescriptor
extends AbstractParticipantDescriptor<RenderContextProvider> {
    private final PluginController pluginController;
    private TemplateDefinition subjectTemplate;
    private String medium;
    private ModuleCompleteKey notificationKey;
    private ModuleDescriptor bodyDescriptor;
    private TemplateDefinition bodyTemplate;

    public NotificationTemplateDescriptor(ModuleFactory moduleFactory, PluginController pluginController) {
        this(moduleFactory, pluginController, null);
    }

    public NotificationTemplateDescriptor(ModuleFactory moduleFactory, PluginController pluginController, ModuleCompleteKey notificationKey) {
        super(moduleFactory);
        this.pluginController = pluginController;
        this.notificationKey = notificationKey;
    }

    protected void validate(Element element) {
        super.validate(element);
        if (element.attributeValue("subject") == null) {
            throw new ValidationException("There were validation errors:", List.of("Missing attribute [subject=\"Velocity expression\"] denoting the subject for this medium, e.g. [subject=\"$content.space.moduleKey > $content.title\"], on"));
        }
        if (element.attributeValue("for-medium") == null) {
            throw new ValidationException("There were validation errors:", List.of("Missing attribute [for-medium=\"moduleKey\"] denoting the moduleKey of the medium this notification template is used for, e.g. [for-medium=\"email\"], on"));
        }
        if (this.notificationKey == null && element.attributeValue("for-notification") == null) {
            throw new ValidationException("There were validation errors:", List.of("Missing attribute [for-notification=\"pluginKey:moduleCompleteKey\"] denoting the moduleKey of the notification that this notification template is used for, e.g. [for-notification=\"email-notification-plugin:page-created-notification\"], on"));
        }
    }

    public void init(@NonNull Plugin plugin, @NonNull Element descriptor) throws PluginParseException {
        super.init(plugin, descriptor);
        this.subjectTemplate = TemplateDefinition.vmTemplate((String)descriptor.attributeValue("subject"));
        this.medium = descriptor.attributeValue("for-medium");
        if (this.notificationKey == null) {
            try {
                this.notificationKey = new ModuleCompleteKey(descriptor.attributeValue("for-notification"));
            }
            catch (IllegalArgumentException ignored) {
                this.notificationKey = new ModuleCompleteKey(this.getPluginKey(), descriptor.attributeValue("for-notification"));
            }
        }
        this.bodyDescriptor = new WebResourceModuleDescriptor(this.moduleFactory, null);
        Element body = descriptor.element("body");
        if (body instanceof Dom4jDelegatingElement) {
            org.dom4j.Element bodyDescriptorElement = ((Dom4jDelegatingElement)body).getDelegate();
            if (bodyDescriptorElement.attributeValue("key") == null) {
                bodyDescriptorElement.addAttribute("key", this.key + "-" + bodyDescriptorElement.getName());
            }
            this.bodyDescriptor.init(plugin, (Element)new Dom4jDelegatingElement(bodyDescriptorElement));
        } else {
            this.bodyDescriptor.init(plugin, body);
        }
        this.bodyTemplate = TemplateDefinition.soyTemplate((String)this.bodyDescriptor.getCompleteKey(), (String)body.attributeValue("use"));
        plugin.addModuleDescriptor(this.bodyDescriptor);
    }

    public void enabled() {
        super.enabled();
        this.pluginController.enablePluginModule(this.bodyDescriptor.getCompleteKey());
    }

    public TemplateDefinition getSubjectTemplate() {
        return this.subjectTemplate;
    }

    public String getMedium() {
        return this.medium;
    }

    public ModuleCompleteKey getNotificationKey() {
        return this.notificationKey;
    }

    public TemplateDefinition getBodyTemplate() {
        return this.bodyTemplate;
    }
}

