/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.impl.descriptors;

import com.atlassian.confluence.notifications.PayloadTransformer;
import com.atlassian.confluence.notifications.ProductionAwareLoggerSwitch;
import com.atlassian.confluence.notifications.impl.descriptors.AbstractParticipantDescriptor;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationException;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;

public class NotificationTransformerDescriptor
extends AbstractParticipantDescriptor<PayloadTransformer> {
    private static final ProductionAwareLoggerSwitch log = ProductionAwareLoggerSwitch.forCaller();
    private List<Class> scopeClasses;
    private final ResettableLazyReference<Predicate<Class>> transformerPredicate = new ResettableLazyReference<Predicate<Class>>(){

        protected Predicate<Class> create() {
            return notificationCandidate -> {
                if (!((PayloadTransformer)NotificationTransformerDescriptor.this.getModule()).getSourceType().isAssignableFrom((Class<?>)notificationCandidate)) {
                    log.onlyTrace("[%s] doesn't want to consume [%s].", new Object[]{((PayloadTransformer)NotificationTransformerDescriptor.this.getModule()).getClass().getName(), notificationCandidate.getName()});
                    return false;
                }
                if (!NotificationTransformerDescriptor.this.scopeClasses.isEmpty()) {
                    for (Class scopeClass : NotificationTransformerDescriptor.this.scopeClasses) {
                        if (!scopeClass.isAssignableFrom((Class<?>)notificationCandidate)) continue;
                        return true;
                    }
                    log.onlyTrace("[%s] doesn't want to consume [%s] because it's scoped to the following classes [%s].", new Object[]{((PayloadTransformer)NotificationTransformerDescriptor.this.getModule()).getClass().getName(), notificationCandidate.getName(), ToStringBuilder.reflectionToString((Object)NotificationTransformerDescriptor.this.scopeClasses.toArray(), (ToStringStyle)ToStringStyle.SIMPLE_STYLE)});
                    return false;
                }
                return true;
            };
        }
    };
    private ModuleCompleteKey forNotificationDescriptor;
    private int weight;

    public NotificationTransformerDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public NotificationTransformerDescriptor(ModuleFactory moduleFactory, ModuleCompleteKey forNotificationDescriptor) {
        super(moduleFactory);
        this.forNotificationDescriptor = forNotificationDescriptor;
    }

    protected void validate(Element element) {
        super.validate(element);
        if (element.attributeValue("for-notification") == null) {
            throw new ValidationException("There were validation errors:", List.of("Missing attribute 'for-notification', which should contain the module complete key of the notification descriptor that this descriptor is tied to"));
        }
    }

    public void init(@NonNull Plugin plugin, @NonNull Element descriptor) throws PluginParseException {
        super.init(plugin, descriptor);
        ImmutableList.Builder scopeClassesBuilder = ImmutableList.builder();
        for (Element scopeDescriptor : descriptor.elements("scope")) {
            scopeClassesBuilder.add((Object)this.loadScopeClass(scopeDescriptor));
        }
        this.scopeClasses = scopeClassesBuilder.build();
        if (this.forNotificationDescriptor == null) {
            try {
                this.forNotificationDescriptor = new ModuleCompleteKey(descriptor.attributeValue("for-notification"));
            }
            catch (IllegalArgumentException ignored) {
                this.forNotificationDescriptor = new ModuleCompleteKey(this.getPluginKey(), descriptor.attributeValue("for-notification"));
            }
        }
        this.weight = descriptor.attributeValue("weight") == null ? 0 : Integer.parseInt(descriptor.attributeValue("weight"));
    }

    private Class loadScopeClass(Element descriptor) {
        String scopeClassName = descriptor.attributeValue("class");
        Preconditions.checkNotNull((Object)scopeClassName, (String)"Descriptor [%s] in plugin [%] doesn't contain a class attribute.", (Object)descriptor, (Object)this.plugin);
        return this.loadClassUnchecked(scopeClassName);
    }

    public ModuleCompleteKey keyForNotificationDescriptor() {
        return this.forNotificationDescriptor;
    }

    public boolean transforms(Class notificationCandidate) {
        return ((Predicate)this.transformerPredicate.get()).apply((Object)notificationCandidate);
    }

    public int getWeight() {
        return this.weight;
    }
}

