/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.impl.descriptors;

import com.atlassian.confluence.notifications.ProductionAwareLoggerSwitch;
import com.atlassian.confluence.notifications.impl.VersionedResourceTransformer;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.internal.module.Dom4jDelegatingElement;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Pair;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public final class VersionedResourceDescriptor
extends WebResourceModuleDescriptor {
    private static final ProductionAwareLoggerSwitch log = ProductionAwareLoggerSwitch.forClass(VersionedResourceDescriptor.class);
    private List<WebResourceModuleDescriptor> webResourceModuleDescriptors;

    public VersionedResourceDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory, null);
    }

    public void init(@NonNull Plugin plugin, @NonNull Element element) throws PluginParseException {
        if (element instanceof Dom4jDelegatingElement) {
            Dom4jDelegatingElement dom4jDelegatingElement = (Dom4jDelegatingElement)element;
            Pair<org.dom4j.Element, Iterable<org.dom4j.Element>> webResourceDescriptors = VersionedResourceTransformer.parse(dom4jDelegatingElement.getDelegate(), () -> plugin).transform();
            ImmutableList.Builder webResourceModuleDescriptorBuilder = ImmutableList.builder();
            for (org.dom4j.Element webResourceElement : (Iterable)webResourceDescriptors.right()) {
                WebResourceModuleDescriptor webResourceModuleDescriptor = new WebResourceModuleDescriptor(this.moduleFactory, null);
                webResourceModuleDescriptor.init(plugin, (Element)new Dom4jDelegatingElement(webResourceElement));
                plugin.addModuleDescriptor((ModuleDescriptor)webResourceModuleDescriptor);
                webResourceModuleDescriptorBuilder.add((Object)webResourceModuleDescriptor);
            }
            super.init(plugin, (Element)new Dom4jDelegatingElement((org.dom4j.Element)webResourceDescriptors.left()));
            this.webResourceModuleDescriptors = webResourceModuleDescriptorBuilder.build();
            log.onlyTrace("versioned resources:\n%s\n", new Object[]{new LazyToString(webResourceDescriptors)});
        }
    }

    public void enabled() {
        for (WebResourceModuleDescriptor webResourceModuleDescriptor : this.webResourceModuleDescriptors) {
            webResourceModuleDescriptor.enabled();
        }
        super.enabled();
    }

    public void disabled() {
        super.disabled();
        for (WebResourceModuleDescriptor webResourceModuleDescriptor : Lists.reverse(this.webResourceModuleDescriptors)) {
            webResourceModuleDescriptor.disabled();
        }
    }

    private record LazyToString(Pair<org.dom4j.Element, Iterable<org.dom4j.Element>> webResourceDescriptors) {
        @Override
        public String toString() {
            OutputFormat format = OutputFormat.createPrettyPrint();
            StringWriter out = new StringWriter();
            XMLWriter writer = new XMLWriter((Writer)out, format);
            try {
                for (org.dom4j.Element e : (Iterable)this.webResourceDescriptors.right()) {
                    writer.write(e);
                }
                writer.write((org.dom4j.Element)this.webResourceDescriptors.left());
                writer.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return out.toString();
        }
    }
}

