/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.impl.soy;

import com.atlassian.confluence.notifications.AnalyticsRenderContext;
import com.atlassian.confluence.notifications.impl.jwt.JwtTokenGenerator;
import com.atlassian.confluence.notifications.impl.soy.AnalyticsLinkBuilder;
import com.atlassian.confluence.notifications.impl.soy.UrlBuilderFunction;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultAnalyticsLinkBuilder
implements AnalyticsLinkBuilder {
    private static final String ATTRIBUTE_KEY_FORMAT = "src.%s.%s";
    private final AnalyticsRenderContext analyticsRenderContext;
    private UrlBuilderFunction urlBuilderFunction;

    @Autowired
    public DefaultAnalyticsLinkBuilder(AnalyticsRenderContext analyticsRenderContext, JwtTokenGenerator jwtTokenGenerator) {
        this.analyticsRenderContext = analyticsRenderContext;
        this.urlBuilderFunction = new UrlBuilderFunction(jwtTokenGenerator);
    }

    @VisibleForTesting
    public void setUrlBuilderFunction(UrlBuilderFunction urlBuilderFunction) {
        this.urlBuilderFunction = urlBuilderFunction;
    }

    @Override
    public String buildAnalyticsQuery(String link, Optional<String> action) {
        AnalyticsRenderContext.Context context = this.analyticsRenderContext.getContext();
        if (context == null) {
            return link;
        }
        String medium = context.getMediumKey();
        ImmutableMap.Builder paramBuilder = ImmutableMap.builder().put((Object)"src", (Object)medium).put((Object)this.transformKey(medium, "product"), (Object)"confluence-server").put((Object)this.transformKey(medium, "timestamp"), (Object)String.valueOf(context.getTimestamp().getTime())).put((Object)this.transformKey(medium, "notification"), (Object)context.getNotificationKey().getCompleteKey());
        if (context.optionalRecipient().isPresent()) {
            paramBuilder.put((Object)this.transformKey(medium, "recipient"), (Object)context.optionalRecipient().get().getStringValue());
        }
        action.ifPresent(s -> paramBuilder.put((Object)this.transformKey(medium, "action"), s));
        return this.urlBuilderFunction.build(link, (Map<String, String>)paramBuilder.build(), action.orElse(null), context.optionalRecipient().orElse(null));
    }

    private String transformKey(String source, String attribute) {
        return String.format(ATTRIBUTE_KEY_FORMAT, source, attribute);
    }
}

