/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.impl.spi;

import com.atlassian.confluence.notifications.AnalyticsRenderContext;
import com.atlassian.confluence.notifications.impl.AnalyticsRenderContextManager;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.velocity.context.OutputMimeTypeAwareVelocityContext;
import com.atlassian.plugin.notifications.api.template.TemplateDefinition;
import com.atlassian.plugin.notifications.spi.NotificationRenderer;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.velocity.context.Context;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceNotificationRenderer
implements NotificationRenderer {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceNotificationRenderer.class);
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final VelocityHelperService velocityHelperService;
    private final AnalyticsRenderContextManager contextManager;

    public ConfluenceNotificationRenderer(SoyTemplateRenderer soyTemplateRenderer, VelocityHelperService velocityHelperService, AnalyticsRenderContextManager contextManager) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.velocityHelperService = velocityHelperService;
        this.contextManager = contextManager;
    }

    public void render(TemplateDefinition template, Map<String, Object> context, Writer out) {
        this.render(template, context, Optional.empty(), out);
    }

    public void render(TemplateDefinition template, Map<String, Object> context, Optional<String> outputMimeType, Writer out) {
        this.contextManager.setContext((AnalyticsRenderContext.Context)context.get("analyticsContext"), () -> this.renderInternal(template, context, outputMimeType.orElse(null), out));
    }

    void renderInternal(TemplateDefinition template, Map<String, Object> context, @Nullable String outputMimeType, Writer out) {
        switch (template.getType()) {
            case SOY: {
                this.soyTemplateRenderer.render((Appendable)out, template.getTemplatePackage(), template.getTemplate(), ConfluenceNotificationRenderer.withoutEntriesWithNonStringKeys(context), ConfluenceNotificationRenderer.withoutEntriesWithNonStringKeys(ConfluenceNotificationRenderer.getSoyInjectedData(context)));
                break;
            }
            case VM: {
                try {
                    out.write(this.velocityHelperService.getRenderedContent(template.getTemplate(), ConfluenceNotificationRenderer.createVelocityContext(context, outputMimeType)));
                    break;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    private static Context createVelocityContext(Map<String, Object> context, @Nullable String outputMimeType) {
        if (outputMimeType == null) {
            return OutputMimeTypeAwareVelocityContext.newHtmlContext(context);
        }
        OutputMimeTypeAwareVelocityContext confluenceVelocityContext = new OutputMimeTypeAwareVelocityContext(context);
        confluenceVelocityContext.setOutputMimeType(outputMimeType);
        return confluenceVelocityContext;
    }

    private static Map<String, Object> getSoyInjectedData(Map<String, Object> context) {
        Object val = context.get("soyInjectedData");
        if (val instanceof Map) {
            Map map = (Map)val;
            return map;
        }
        return Collections.emptyMap();
    }

    private static Map<String, Object> withoutEntriesWithNonStringKeys(Map<?, ?> map) {
        HashMap<String, Object> filteredMap = new HashMap<String, Object>();
        map.forEach((key, value) -> {
            if (key instanceof String) {
                Map<String, Object> map2;
                String stringKey = (String)key;
                if (value instanceof Map) {
                    Map mapValue = value;
                    map2 = ConfluenceNotificationRenderer.withoutEntriesWithNonStringKeys(mapValue);
                } else {
                    map2 = value;
                }
                filteredMap.put(stringKey, map2);
            } else {
                log.debug("Removing non-string key of {} from context map {}", key == null ? null : key.getClass(), (Object)map);
            }
        });
        return filteredMap;
    }
}

