/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.like.actions;

import com.atlassian.annotations.security.UnlicensedSiteAccess;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.like.LikeManager;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.struts.xsrf.XsrfProtectionRequired;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

@UnlicensedSiteAccess
@ReadOnlyAccessBlocked
public class LikeAction
extends ConfluenceActionSupport {
    private LikeManager likeManager;
    private ContentEntityManager contentEntityManager;
    private long contentId;
    private String url;

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    @XsrfProtectionRequired
    public String execute() {
        ContentEntityObject content = this.contentEntityManager.getById(this.contentId);
        if (content == null) {
            ServletActionContext.getResponse().setStatus(404);
            return "error";
        }
        this.likeManager.addLike(content, AuthenticatedUserThreadLocal.get());
        this.url = content.getUrlPath();
        if (!(content instanceof Comment)) {
            this.url = this.url + "#like-section";
        }
        return "success";
    }

    public String getRedirectUrl() {
        return this.url;
    }

    public void setLikeManager(LikeManager likeManager) {
        this.likeManager = likeManager;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    @StrutsParameter
    public void setContentId(long contentId) {
        this.contentId = contentId;
    }
}

