/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.like.notifications;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.people.KnownUser;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.follow.FollowManager;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.notifications.Notification;
import com.atlassian.confluence.notifications.RenderContextProviderTemplate;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.confluence.plugins.like.notifications.LikePayload;
import com.atlassian.confluence.plugins.like.notifications.MaybeNot;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.notifications.api.medium.NotificationAddress;
import com.atlassian.plugin.notifications.api.medium.ServerConfiguration;
import com.atlassian.plugin.notifications.api.medium.recipient.RoleRecipient;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import io.atlassian.fugue.Maybe;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractLikeEventRenderContextProvider
extends RenderContextProviderTemplate<LikePayload> {
    private final ContentService contentService;
    private final UserAccessor userAccessor;
    private final FollowManager followManager;

    public AbstractLikeEventRenderContextProvider(ContentService contentService, UserAccessor userAccessor, FollowManager followManager) {
        super(LikePayload.class);
        this.contentService = contentService;
        this.userAccessor = userAccessor;
        this.followManager = followManager;
    }

    public Optional<Map<String, Object>> checkedCreate(Notification<LikePayload> notification, ServerConfiguration serverConfiguration, NotificationAddress notificationAddress) {
        return Optional.empty();
    }

    public Optional<Map<String, Object>> checkedCreate(Notification<LikePayload> notification, ServerConfiguration serverConfiguration, RoleRecipient recipient) {
        Maybe<Map<String, Object>> maybeSubContext;
        ConfluenceUser recipientUser = this.userAccessor.getUserByKey(recipient.getUserKey());
        NotificationContext context = new NotificationContext();
        LikePayload payload = (LikePayload)notification.getPayload();
        ContentId contentId = ContentId.of((long)payload.getContentId());
        Optional maybeContent = this.contentService.find(this.getMediumSpecificExpansions()).withId(contentId).fetch();
        if (maybeContent.isEmpty()) {
            return Optional.empty();
        }
        Content content = (Content)maybeContent.get();
        UserKey userKey = (UserKey)payload.getOriginatorUserKey().get();
        ConfluenceUser liker = this.userAccessor.getUserByKey(userKey);
        boolean recipientIsAuthor = false;
        ConfluenceUser author = null;
        Person authorAsPerson = content.getHistory().getCreatedBy();
        if (authorAsPerson instanceof KnownUser) {
            Optional authorKey = authorAsPerson.optionalUserKey();
            Preconditions.checkArgument((boolean)authorKey.isPresent());
            author = this.userAccessor.getUserByKey((UserKey)authorKey.get());
            boolean bl = recipientIsAuthor = author != null && author.getKey() != null && author.getKey().equals((Object)recipient.getUserKey());
        }
        if ((maybeSubContext = this.getMediumSpecificContext(content, payload, recipientIsAuthor)) instanceof MaybeNot) {
            return Optional.empty();
        }
        context.putAll((Map)maybeSubContext.get());
        context.put("content", (Object)content);
        context.put("modifier", (Object)liker);
        context.put("author", (Object)author);
        context.put("recipientIsAuthor", (Object)recipientIsAuthor);
        context.setManageNotificationOverridden(true);
        if (!recipientIsAuthor && this.followManager.isUserFollowing((User)recipientUser, (User)liker)) {
            context.setWatchType(Notification.WatchType.NETWORK);
        }
        return Optional.of(context.getMap());
    }

    protected abstract Expansion[] getMediumSpecificExpansions();

    protected abstract Maybe<Map<String, Object>> getMediumSpecificContext(Content var1, LikePayload var2, boolean var3);
}

