/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.like.notifications;

import com.atlassian.confluence.api.model.BaseApiEnum;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.like.LikeEvent;
import com.atlassian.confluence.notifications.PayloadTransformerTemplate;
import com.atlassian.confluence.notifications.batch.payload.BatchingPayloadTransformer;
import com.atlassian.confluence.notifications.batch.service.BatchingKey;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.plugins.like.notifications.LikePayload;
import com.atlassian.confluence.plugins.like.notifications.SimpleLikePayload;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import java.util.Optional;

public class CreateLikeEventPayloadTransformer
extends PayloadTransformerTemplate<LikeEvent, LikePayload>
implements BatchingPayloadTransformer<LikePayload> {
    private final UserAccessor userAccessor;

    protected CreateLikeEventPayloadTransformer(UserAccessor userAccessor) {
        super(LikeEvent.class);
        this.userAccessor = userAccessor;
    }

    public BatchingKey getBatchingColumnValue(LikePayload likePayload) {
        if (likePayload == null || !likePayload.getContentType().in(new BaseApiEnum[]{ContentType.BLOG_POST, ContentType.PAGE, ContentType.COMMENT})) {
            return BatchingKey.NO_BATCHING;
        }
        return new BatchingKey(Long.toString(likePayload.getContentId()), likePayload.getContentType().getType());
    }

    public Optional<LikePayload> checkedCreate(LikeEvent likeEvent) {
        UserKey userKey;
        ContentEntityObject owner;
        ContentEntityObject content = likeEvent.getContent();
        User originatingUser = likeEvent.getOriginatingUser();
        if (originatingUser == null) {
            return Optional.empty();
        }
        if (content instanceof Comment && (owner = ((Comment)content).getContainer()) == null) {
            return Optional.empty();
        }
        if (originatingUser instanceof ConfluenceUser) {
            userKey = ((ConfluenceUser)originatingUser).getKey();
        } else {
            ConfluenceUser user = this.userAccessor.getUserByName(originatingUser.getName());
            if (user == null) {
                return Optional.empty();
            }
            userKey = user.getKey();
        }
        SimpleLikePayload payload = new SimpleLikePayload(content.getId(), ContentType.valueOf((String)content.getType()), userKey.getStringValue());
        return Optional.of(payload);
    }
}

