/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.like.notifications;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.content.render.xhtml.view.excerpt.Excerpter;
import com.atlassian.confluence.follow.FollowManager;
import com.atlassian.confluence.plugins.like.notifications.AbstractLikeEventRenderContextProvider;
import com.atlassian.confluence.plugins.like.notifications.LikePayload;
import com.atlassian.confluence.plugins.like.notifications.MaybeNot;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.confluence.user.UserAccessor;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.Map;

public class LikeEventEmailRenderContextProvider
extends AbstractLikeEventRenderContextProvider {
    private final Excerpter excerpter;

    public LikeEventEmailRenderContextProvider(ContentService contentService, UserAccessor userAccessor, FollowManager followManager, Excerpter excerpter) {
        super(contentService, userAccessor, followManager);
        this.excerpter = excerpter;
    }

    @Override
    protected Expansion[] getMediumSpecificExpansions() {
        return ExpansionsParser.parse((String)"space,history,container,body.export_view");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Maybe<Map<String, Object>> getMediumSpecificContext(Content content, LikePayload payload, boolean recipientIsAuthor) {
        String excerpt;
        Content subjectContent;
        if (ContentType.COMMENT.equals((Object)payload.getContentType())) {
            if (!(content.getContainer() instanceof Content)) return MaybeNot.becauseOf("Container should exist for comment and should be of type content.", new Object[0]);
            subjectContent = (Content)content.getContainer();
        } else {
            subjectContent = content;
        }
        try {
            excerpt = this.excerpter.createExcerpt(content);
        }
        catch (Exception e) {
            return MaybeNot.becauseOfException(e);
        }
        String emailSummaryI18nKey = "likes.notification.adg.body.user.likes." + (recipientIsAuthor ? "your." : "") + String.valueOf(payload.getContentType());
        long messageId = payload.getContentId();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("subjectContent", subjectContent);
        context.put("contentBody", excerpt);
        context.put("emailSummaryI18nKey", emailSummaryI18nKey);
        context.put("messageId", String.valueOf(messageId));
        return Option.some(context);
    }
}

