/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.like.notifications;

import com.atlassian.confluence.core.None;
import io.atlassian.fugue.Effect;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Suppliers;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

abstract class MaybeNot<T>
implements Maybe<T> {
    public static <T> Maybe<T> becauseOfNoResult(Maybe<?> maybe) {
        return None.becauseOfNoResult(maybe);
    }

    public static <T> Maybe<T> becauseOf(String message, Object ... args) {
        return MaybeNot.becauseOfException(new RuntimeException(ArrayUtils.isEmpty((Object[])args) ? message : String.format(message, args)));
    }

    public static <T> Maybe<T> becauseOfException(final Exception exception) {
        return new MaybeNot<T>(){

            public T get() {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new RuntimeException(exception);
            }
        };
    }

    private MaybeNot() {
    }

    public T getOrError(Supplier<String> msg) {
        try {
            return (T)this.get();
        }
        catch (RuntimeException e) {
            throw new RuntimeException(msg.get(), e);
        }
    }

    public T getOr(Supplier<? extends T> supplier) {
        return supplier.get();
    }

    public T getOrElse(Supplier<? extends T> supplier) {
        return this.getOr(supplier);
    }

    public <X extends Throwable> T getOrThrow(Supplier<X> xSupplier) throws X {
        throw (Throwable)xSupplier.get();
    }

    public <B extends T> T getOrElse(B other) {
        return this.getOrElse((B)Suppliers.ofInstance(other));
    }

    public void foreach(Effect<? super T> effect) {
    }

    public T getOrNull() {
        return null;
    }

    public boolean exists(Predicate<? super T> p) {
        return false;
    }

    public @NonNull Iterator<T> iterator() {
        return Collections.emptyIterator();
    }

    public boolean forall(Predicate<? super T> p) {
        return true;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean isDefined() {
        return false;
    }

    public boolean contains(T elem) {
        return false;
    }
}

