/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.like.notifications;

import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.plugins.like.notifications.LikePayload;
import com.atlassian.sal.api.user.UserKey;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;

public class SimpleLikePayload
implements LikePayload {
    @JsonProperty
    private long contentId;
    @JsonProperty
    private ContentType contentType;
    @JsonProperty
    private String originator;

    SimpleLikePayload() {
    }

    SimpleLikePayload(long contentId, ContentType contentType, String originator) {
        this.contentId = contentId;
        this.contentType = contentType;
        this.originator = originator;
    }

    @Override
    public long getContentId() {
        return this.contentId;
    }

    @Override
    public ContentType getContentType() {
        return this.contentType;
    }

    public Optional<String> getNotificationKey() {
        return Optional.of(this.originator);
    }

    public Optional<UserKey> getOriginatorUserKey() {
        return Optional.ofNullable(this.originator).map(UserKey::new);
    }
}

