/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.like.rest.resources;

import com.atlassian.confluence.follow.FollowManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;

@Path(value="/user/{username}")
public class UserResource {
    private final UserAccessor userAccessor;
    private final PermissionManager permissionManager;
    private final FollowManager followManager;

    @Inject
    public UserResource(UserAccessor userAccessor, PermissionManager permissionManager, FollowManager followManager) {
        this.userAccessor = userAccessor;
        this.permissionManager = permissionManager;
        this.followManager = followManager;
    }

    @PUT
    @Path(value="/following")
    @Consumes(value={"application/json"})
    public Response addToFollowing(@QueryParam(value="username") String candidateUsername, @PathParam(value="username") String currentUsername) {
        if (!currentUsername.equals(AuthenticatedUserThreadLocal.getUsername())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"You can only alter your own network").build();
        }
        ConfluenceUser user = this.userAccessor.getUserByName(currentUsername);
        if (user == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("User with name \"" + currentUsername + "\" does not exist")).build();
        }
        ConfluenceUser candidate = this.userAccessor.getUserByName(candidateUsername);
        if (candidate == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("User with name \"" + candidateUsername + "\" does not exist")).build();
        }
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, PermissionManager.TARGET_APPLICATION)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"You do not have sufficient privileges.").build();
        }
        this.followManager.followUser(user, candidate);
        return Response.ok().build();
    }
}

