/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.server.impl.util;

import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailUtils;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MessageCreator {
    @Deprecated
    public void updateMimeMessage(Email email, String defaultFrom, String prefix, MimeMessage message) throws MailException, MessagingException, UnsupportedEncodingException {
        this.updateMimeMessage(email, defaultFrom, null, prefix, message);
    }

    public void updateMimeMessage(Email email, String defaultFrom, String defaultReplyTo, String prefix, MimeMessage message) throws MailException, MessagingException, UnsupportedEncodingException {
        String from = StringUtils.trim((String)email.getFrom());
        String fromName = email.getFromName();
        String to = email.getTo();
        String cc = email.getCc();
        String bcc = email.getBcc();
        String replyTo = email.getReplyTo();
        String inReplyTo = email.getInReplyTo();
        String subject = email.getSubject();
        String body = email.getBody();
        String mimeType = email.getMimeType();
        String encoding = email.getEncoding();
        Map headers = email.getHeaders();
        Multipart multipart = email.getMultipart();
        if (StringUtils.isBlank((CharSequence)StringUtils.trim((String)to)) && StringUtils.isBlank((CharSequence)StringUtils.trim((String)cc)) && StringUtils.isBlank((CharSequence)StringUtils.trim((String)bcc))) {
            throw new MailException("Tried to send mail (" + subject + ") with no recipients.");
        }
        message.setSentDate(Calendar.getInstance().getTime());
        if (to != null) {
            message.setRecipients(Message.RecipientType.TO, (Address[])MailUtils.parseAddresses(to));
        }
        if (cc != null) {
            message.setRecipients(Message.RecipientType.CC, (Address[])MailUtils.parseAddresses(cc));
        }
        if (bcc != null) {
            message.setRecipients(Message.RecipientType.BCC, (Address[])MailUtils.parseAddresses(bcc));
        }
        if (replyTo != null) {
            message.setReplyTo((Address[])MailUtils.parseAddresses(replyTo));
        } else if (StringUtils.isNotBlank((CharSequence)defaultReplyTo)) {
            message.setReplyTo((Address[])MailUtils.parseAddresses(defaultReplyTo));
        }
        if (inReplyTo != null) {
            message.setHeader("In-Reply-To", inReplyTo);
        }
        if (StringUtils.isNotBlank((CharSequence)from)) {
            message.setFrom((Address)this.buildFromFieldAsInternetAddress(from, fromName, encoding));
        } else if (StringUtils.isNotBlank((CharSequence)defaultFrom)) {
            message.setFrom((Address)this.buildFromFieldAsInternetAddress(defaultFrom, fromName, encoding));
        } else {
            throw new MailException("Tried to send mail (" + subject + ") from no one (no 'from' and 'default from' specified).");
        }
        Object fullSubject = subject;
        if (this.shouldIncludeSubjectPrefix(prefix, email)) {
            fullSubject = prefix + " " + (String)fullSubject;
        }
        if (encoding != null) {
            message.setSubject((String)fullSubject, encoding);
        } else {
            message.setSubject((String)fullSubject);
        }
        Object mimeTypeAndEncoding = mimeType;
        if (encoding != null) {
            mimeTypeAndEncoding = (String)mimeTypeAndEncoding + "; charset=" + encoding;
        }
        if (multipart != null) {
            if (StringUtils.isNotBlank((CharSequence)body)) {
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.setContent((Object)body, (String)mimeTypeAndEncoding);
                messageBodyPart.setDisposition("inline");
                multipart.addBodyPart((BodyPart)messageBodyPart, 0);
            }
            message.setContent(multipart);
        } else {
            message.setContent((Object)body, (String)mimeTypeAndEncoding);
        }
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                message.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private boolean shouldIncludeSubjectPrefix(String prefix, Email email) {
        return !email.isExcludeSubjectPrefix() && StringUtils.isNotBlank((CharSequence)prefix);
    }

    private InternetAddress buildFromFieldAsInternetAddress(String fromAddress, String fromName, String encoding) throws MessagingException, UnsupportedEncodingException {
        InternetAddress internetAddress = new InternetAddress(fromAddress);
        if (StringUtils.isNotBlank((CharSequence)fromName) && internetAddress.getPersonal() == null) {
            if (encoding != null) {
                internetAddress.setPersonal(fromName, encoding);
            } else {
                internetAddress.setPersonal(fromName);
            }
        }
        return internetAddress;
    }
}

