/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theme.internal.request;

import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.theme.api.Theme;
import com.atlassian.theme.api.ThemeColorMode;
import com.atlassian.theme.api.request.RequestScopeThemeService;
import com.atlassian.theme.internal.DefaultThemes;
import com.atlassian.theme.internal.api.ThemeService;
import com.atlassian.theme.internal.api.request.RequestScopeThemeOverrideService;
import com.atlassian.theme.internal.api.user.PreferredColorMode;
import com.atlassian.theme.internal.api.user.UserThemeService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ReturnValuesAreNonnullByDefault
public class DefaultRequestScopeThemeService
implements RequestScopeThemeService,
RequestScopeThemeOverrideService {
    private static final Logger log = LoggerFactory.getLogger(DefaultRequestScopeThemeService.class);
    private static final String COLOR_MODE_OVERRIDE_ATTRIBUTE_KEY = "atlassian-theme-color-mode-override";
    private static final String DARK_THEME_OVERRIDE_ATTRIBUTE_KEY = "atlassian-theme-dark-override";
    private static final String LIGHT_THEME_OVERRIDE_ATTRIBUTE_KEY = "atlassian-theme-light-override";
    private static final String MATCH_USER_AGENT_OVERRIDE_ATTRIBUTE_KEY = "atlassian-theme-match-ua-override";
    private final UserManager userManager;
    private final ThemeService themeService;
    private final UserThemeService userThemeService;
    private final boolean originalThemeIsDefaultLightModeTheme;
    private final boolean originalThemeEnabled;
    private final boolean shouldMatchUserAgentByDefault;

    public DefaultRequestScopeThemeService(@Nonnull UserManager userManager, @Nonnull ThemeService themeService, @Nonnull UserThemeService userThemeService, boolean originalThemeIsDefaultLightModeTheme, boolean originalThemeEnabled, boolean shouldMatchUserAgentByDefault) {
        if (originalThemeIsDefaultLightModeTheme && !originalThemeEnabled) {
            throw new IllegalArgumentException("Original theme needs to be enabled for it to be the default");
        }
        this.userManager = Objects.requireNonNull(userManager, "userManager");
        this.themeService = Objects.requireNonNull(themeService, "themeService");
        this.userThemeService = Objects.requireNonNull(userThemeService, "userThemeService");
        this.originalThemeIsDefaultLightModeTheme = originalThemeIsDefaultLightModeTheme;
        this.originalThemeEnabled = originalThemeEnabled;
        this.shouldMatchUserAgentByDefault = shouldMatchUserAgentByDefault;
    }

    @Nonnull
    public Theme getPreferredDarkTheme(@Nonnull HttpServletRequest httpServletRequest) {
        Optional matchingTheme;
        Objects.requireNonNull(httpServletRequest, "httpServletRequest");
        Object darkThemeOverride = httpServletRequest.getAttribute(DARK_THEME_OVERRIDE_ATTRIBUTE_KEY);
        if (!Objects.isNull(darkThemeOverride) && darkThemeOverride instanceof String && (matchingTheme = this.themeService.findMatchingTheme(ThemeColorMode.DARK, (String)darkThemeOverride)).isPresent()) {
            return (Theme)matchingTheme.get();
        }
        return Optional.ofNullable(this.userManager.getRemoteUserKey(httpServletRequest)).flatMap(arg_0 -> ((UserThemeService)this.userThemeService).getPreferredDarkTheme(arg_0)).orElse(DefaultThemes.DARK);
    }

    @Nonnull
    public Theme getPreferredLightTheme(@Nonnull HttpServletRequest httpServletRequest) {
        Optional matchingTheme;
        Objects.requireNonNull(httpServletRequest, "httpServletRequest");
        Object lightThemeOverride = httpServletRequest.getAttribute(LIGHT_THEME_OVERRIDE_ATTRIBUTE_KEY);
        if (!Objects.isNull(lightThemeOverride) && lightThemeOverride instanceof String && (matchingTheme = this.themeService.findMatchingTheme(ThemeColorMode.LIGHT, (String)lightThemeOverride)).isPresent()) {
            return (Theme)matchingTheme.get();
        }
        if (!this.originalThemeEnabled) {
            return DefaultThemes.LIGHT;
        }
        Theme defaultTheme = this.originalThemeIsDefaultLightModeTheme ? DefaultThemes.ORIGINAL : DefaultThemes.LIGHT;
        return Optional.ofNullable(this.userManager.getRemoteUserKey(httpServletRequest)).flatMap(arg_0 -> ((UserThemeService)this.userThemeService).getPreferredLightTheme(arg_0)).orElse(defaultTheme);
    }

    @Nonnull
    public String getHtmlAttributesForThisRequest(@Nonnull HttpServletRequest httpServletRequest) {
        Optional<ThemeColorMode> initialColorMode = this.getInitialColorModeWithFallbackAndOverride(httpServletRequest);
        Theme lightTheme = this.getPreferredLightTheme(httpServletRequest);
        Theme darkTheme = this.getPreferredDarkTheme(httpServletRequest);
        ArrayList<Object> attributes = new ArrayList<Object>();
        attributes.add("data-theme=\"dark:" + darkTheme.getThemeKey() + " light:" + lightTheme.getThemeKey() + "\"");
        if (initialColorMode.isPresent()) {
            attributes.add("data-color-mode=\"" + String.valueOf(initialColorMode.get()) + "\"");
        } else {
            attributes.add("data-color-mode-auto");
        }
        return " " + String.join((CharSequence)" ", attributes) + " ";
    }

    @Nonnull
    private Optional<ThemeColorMode> getInitialColorModeWithFallbackAndOverride(@Nonnull HttpServletRequest httpServletRequest) {
        Objects.requireNonNull(httpServletRequest, "httpServletRequest");
        boolean matchUaOverride = Optional.ofNullable(httpServletRequest.getAttribute(MATCH_USER_AGENT_OVERRIDE_ATTRIBUTE_KEY)).filter(matchUserAgentOverrideAttribute -> matchUserAgentOverrideAttribute instanceof Boolean).map(matchUserAgentOverrideAttribute -> (Boolean)matchUserAgentOverrideAttribute).orElse(false);
        if (matchUaOverride) {
            return Optional.empty();
        }
        Optional<ThemeColorMode> override = Optional.ofNullable(httpServletRequest.getAttribute(COLOR_MODE_OVERRIDE_ATTRIBUTE_KEY)).filter(colorModeAttribute -> colorModeAttribute instanceof ThemeColorMode).map(colorModeAttribute -> (ThemeColorMode)colorModeAttribute);
        if (override.isPresent()) {
            return override;
        }
        Optional<PreferredColorMode> preferredColorMode = this.getPreferredColorMode(httpServletRequest);
        if (preferredColorMode.isPresent()) {
            switch (preferredColorMode.get()) {
                case MATCHING: {
                    return Optional.empty();
                }
                case LIGHT: {
                    return Optional.of(ThemeColorMode.LIGHT);
                }
                case DARK: {
                    return Optional.of(ThemeColorMode.DARK);
                }
            }
        }
        return this.shouldMatchUserAgentByDefault ? Optional.empty() : Optional.of(ThemeColorMode.LIGHT);
    }

    private boolean getShouldMatchUserAgent(@Nonnull HttpServletRequest httpServletRequest) {
        Objects.requireNonNull(httpServletRequest, "httpServletRequest");
        Optional<PreferredColorMode> preferredColorMode = this.getPreferredColorMode(httpServletRequest);
        if (preferredColorMode.isPresent() && preferredColorMode.get().equals((Object)PreferredColorMode.MATCHING)) {
            return true;
        }
        return this.shouldMatchUserAgentByDefault;
    }

    private Optional<PreferredColorMode> getPreferredColorMode(@Nonnull HttpServletRequest httpServletRequest) {
        Objects.requireNonNull(httpServletRequest, "httpServletRequest");
        return Optional.ofNullable(this.userManager.getRemoteUserKey(httpServletRequest)).flatMap(arg_0 -> ((UserThemeService)this.userThemeService).getPreferredColorMode(arg_0));
    }

    public void setColorModeOverride(@Nonnull HttpServletRequest httpServletRequest, @Nullable String colorMode) {
        Objects.requireNonNull(httpServletRequest, "httpServletRequest");
        if (DefaultRequestScopeThemeService.isBlankOrNull(colorMode)) {
            return;
        }
        Optional<ThemeColorMode> themeColorMode = Arrays.stream(ThemeColorMode.values()).filter(validColorMode -> validColorMode.toString().equals(colorMode)).findAny();
        if (!themeColorMode.isPresent()) {
            if (log.isDebugEnabled()) {
                log.debug("Provided color override '{}' is not one of the valid choices {}", (Object)colorMode, (Object)Arrays.toString(ThemeColorMode.values()));
            }
            return;
        }
        httpServletRequest.setAttribute(COLOR_MODE_OVERRIDE_ATTRIBUTE_KEY, (Object)themeColorMode.get());
    }

    public void setDarkThemeOverride(@Nonnull HttpServletRequest httpServletRequest, @Nullable String themeKey) {
        Objects.requireNonNull(httpServletRequest, "httpServletRequest");
        if (DefaultRequestScopeThemeService.isBlankOrNull(themeKey)) {
            return;
        }
        httpServletRequest.setAttribute(DARK_THEME_OVERRIDE_ATTRIBUTE_KEY, (Object)themeKey);
    }

    public void setLightThemeOverride(@Nonnull HttpServletRequest httpServletRequest, @Nullable String themeKey) {
        Objects.requireNonNull(httpServletRequest, "httpServletRequest");
        if (DefaultRequestScopeThemeService.isBlankOrNull(themeKey)) {
            return;
        }
        httpServletRequest.setAttribute(LIGHT_THEME_OVERRIDE_ATTRIBUTE_KEY, (Object)themeKey);
    }

    public void setMatchingUserAgentEnabledOverride(@Nonnull HttpServletRequest httpServletRequest, @Nullable Boolean match) {
        Objects.requireNonNull(httpServletRequest, "httpServletRequest");
        if (Objects.isNull(match)) {
            return;
        }
        httpServletRequest.setAttribute(MATCH_USER_AGENT_OVERRIDE_ATTRIBUTE_KEY, (Object)match);
    }

    private static boolean isBlankOrNull(@Nullable String string) {
        return Objects.isNull(string) || string.trim().isEmpty();
    }
}

