/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.macros.multimedia.renderer;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.plugins.macros.multimedia.renderer.AbstractEmbeddedResourceRenderer;
import com.atlassian.confluence.renderer.embedded.EmbeddedObject;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.UrlUtils;
import com.atlassian.confluence.web.UrlBuilder;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.struts.xsrf.XsrfTokenGenerator;
import com.atlassian.velocity.htmlsafe.HtmlFragment;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.stream.Stream;

public class EmbeddedFlashRenderer
extends AbstractEmbeddedResourceRenderer {
    public static final String RESOURCE_TYPE = "application/x-shockwave-flash";
    private final HttpContext httpContext;
    private final XsrfTokenGenerator xsrfTokenGenerator;

    public EmbeddedFlashRenderer(@ComponentImport HttpContext httpContext, @ComponentImport VelocityHelperService velocityHelperService, @ComponentImport XsrfTokenGenerator xsrfTokenGenerator) {
        super(velocityHelperService);
        this.httpContext = httpContext;
        this.xsrfTokenGenerator = xsrfTokenGenerator;
    }

    private String getUrlWithXsrfToken(String givenUrl) {
        URL url;
        URL requestUrl;
        if (this.xsrfTokenGenerator == null) {
            return givenUrl;
        }
        try {
            requestUrl = new URL(this.httpContext.getActiveRequest().getRequestURL().toString());
            url = new URL(requestUrl, givenUrl);
        }
        catch (MalformedURLException e) {
            return givenUrl;
        }
        if (UrlUtils.isSameOrigin((URL)url, (URL)requestUrl)) {
            String token = this.xsrfTokenGenerator.getToken(this.httpContext.getActiveRequest(), true);
            UrlBuilder uBuilder = new UrlBuilder(url.toString());
            uBuilder.add(this.xsrfTokenGenerator.getXsrfTokenName(), token);
            return uBuilder.toString();
        }
        return givenUrl;
    }

    @Override
    protected Map<String, Object> refineParams(Attachment attachment, Map<String, Object> properties) {
        if (!properties.containsKey("classid")) {
            properties.put("classid", "clsid:D27CDB6E-AE6D-11cf-96B8-444553540000");
        }
        if (!properties.containsKey("codebase")) {
            properties.put("codebase", "https://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0");
        }
        if (!properties.containsKey("pluginspage")) {
            properties.put("pluginspage", "https://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash");
        }
        if (!properties.containsKey("type")) {
            properties.put("type", RESOURCE_TYPE);
        }
        if (!properties.containsKey("quality")) {
            properties.put("quality", "high");
        }
        if (!properties.containsKey("loop")) {
            properties.put("loop", "false");
        }
        if (!properties.containsKey("menu")) {
            properties.put("menu", "false");
        }
        if (!properties.containsKey("scale")) {
            properties.put("scale", "exactfit");
        }
        if (!properties.containsKey("wmode")) {
            properties.put("wmode", "transparent");
        }
        if (properties.containsKey("autostart")) {
            properties.put("play", properties.get("autostart"));
        }
        if (properties.get("movie") == null) {
            properties.put("movie", properties.get("object"));
        }
        properties.put("AllowScriptAccess", "never");
        Stream.of("data", "movie", "src").filter(properties::containsKey).forEach(urlKey -> properties.put((String)urlKey, this.getUrlWithXsrfToken(properties.get(urlKey).toString())));
        return properties;
    }

    @Override
    public String renderResource(EmbeddedObject resource, RenderContext context) {
        Map<String, Object> contextMap = this.setupObjectProperties(resource, context);
        Map wrapperContextMap = MacroUtils.defaultVelocityContext();
        wrapperContextMap.put("properties", contextMap);
        wrapperContextMap.put("validObjectTags", validObjectTags);
        wrapperContextMap.put("validEmbedTags", validEmbedTags);
        wrapperContextMap.put("validParamTags", validParamTags);
        wrapperContextMap.put("attachmentDownloadPath", resource.getAttachment().getDownloadPath());
        wrapperContextMap.put("constantObjectTags", this.getConstantTags());
        wrapperContextMap.put("constantParamTags", this.getConstantTags());
        wrapperContextMap.put("constantEmbedTags", this.getConstantTags());
        String renderedObjectHtml = this.velocityHelperService.getRenderedTemplate("templates/embeddedobject.vm", wrapperContextMap);
        wrapperContextMap.put("embeddedObject", new HtmlFragment((Object)renderedObjectHtml));
        return this.velocityHelperService.getRenderedTemplate("templates/embeddedobject-wrapper.vm", wrapperContextMap);
    }

    public boolean matchesType(EmbeddedObject resource) {
        return resource.getContentType().startsWith(RESOURCE_TYPE);
    }

    private Map<String, String> getConstantTags() {
        return Map.of("AllowScriptAccess", "never", "allowNetworking", "none");
    }
}

