/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.api.token;

import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public enum FlowType {
    PKCE("pkce"),
    AUTHORIZATION_CODE("authorization_code"),
    CLIENT_CREDENTIALS("client_credentials"),
    REFRESH_TOKEN("refresh_token");

    final String flowIdentifier;
    public static final Set<FlowType> PUBLIC_FLOWS;

    private FlowType(String flowType) {
        this.flowIdentifier = flowType;
    }

    public static FlowType fromIdentifier(@Nullable String identifier) {
        return Arrays.stream(FlowType.values()).filter(flowType -> flowType.flowIdentifier.equals(identifier)).findFirst().orElse(AUTHORIZATION_CODE);
    }

    public String getFlowIdentifier() {
        return this.flowIdentifier;
    }

    @Deprecated(forRemoval=true)
    public static boolean isClientCredentials(String flowIdentifier) {
        return CLIENT_CREDENTIALS.getFlowIdentifier().equals(flowIdentifier);
    }

    static {
        PUBLIC_FLOWS = Collections.unmodifiableSet(EnumSet.of(PKCE));
    }
}

