/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.zdu.confluence.impl;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.cluster.NodeZduInfo;
import com.atlassian.confluence.cluster.UpgradeFinalizationRun;
import com.atlassian.confluence.cluster.ZduManager;
import com.atlassian.confluence.cluster.ZduStatus;
import com.atlassian.confluence.server.ApplicationState;
import com.atlassian.zdu.internal.api.ClusterManagerAdapter;
import com.atlassian.zdu.internal.api.NodeInfo;
import com.atlassian.zdu.internal.api.UpgradeTaskError;
import com.atlassian.zdu.rest.dto.FinalizationUpgradeTaskErrorDTO;
import com.atlassian.zdu.rest.dto.NodeFinalizationInfoDTO;
import com.atlassian.zdu.rest.dto.NodeInfoDTO;
import com.atlassian.zdu.rest.dto.NodeState;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceClusterManagerAdapter
implements ClusterManagerAdapter {
    static final Logger log = LoggerFactory.getLogger(ConfluenceClusterManagerAdapter.class);
    private final ClusterManager clusterManager;
    private final ZduManager zduManager;

    public ConfluenceClusterManagerAdapter(@Nonnull ClusterManager clusterManager, @Nonnull ZduManager zduManager) {
        this.clusterManager = Objects.requireNonNull(clusterManager);
        this.zduManager = Objects.requireNonNull(zduManager);
    }

    @Override
    public List<NodeInfo> getNodes() {
        ClusterNodeInformation thisNode = this.clusterManager.getThisNodeInformation();
        return ((Stream)this.zduManager.getNodesZduInfo().entrySet().stream().parallel()).map(e -> {
            ClusterNodeInformation node = (ClusterNodeInformation)e.getKey();
            NodeInfoDTO.Builder builder = ConfluenceClusterManagerAdapter.buildNodeInfo(node);
            try {
                NodeZduInfo info = (NodeZduInfo)((CompletionStage)e.getValue()).toCompletableFuture().get(5L, TimeUnit.SECONDS);
                builder.state(this.determineNodeState(info)).buildNumber(info.getBuildNumber()).version(info.getVersion()).local(Objects.equals(thisNode, node)).tasksTotal(info.getLongRunningTaskCount()).activeUserCount(info.getActiveUserCount()).finalization(info.getFinalizationRun().map(run -> NodeFinalizationInfoDTO.builder().lastRequested(Instant.ofEpochMilli(run.getRequestTimestamp())).runsClusterWideTasks(run.runsClusterWideTasks()).errors(run.getErrors().stream().map(ConfluenceClusterManagerAdapter::convertToUpgradeTaskError).toList()).build()).orElse(null));
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                log.warn("Thread interrupted while retrieving status information from cluster node {}.", e.getKey(), (Object)ex);
            }
            catch (Exception ex) {
                log.warn("Failed to retrieve status information from cluster node {}. This can happen temporarily if the node is currently being started/terminated for upgrade. If the problem persists, check the application logs on that node for more details.", e.getKey(), (Object)ex);
            }
            return builder.build();
        }).toList();
    }

    @Override
    public boolean isClustered() {
        return this.clusterManager.isClustered();
    }

    @Override
    public boolean hasClusterFinalizationTasks() {
        return this.zduManager.isPendingDatabaseFinalization();
    }

    private static NodeInfoDTO.Builder buildNodeInfo(ClusterNodeInformation node) {
        return NodeInfoDTO.builder().id(node.getAnonymizedNodeIdentifier()).name(node.humanReadableNodeName().orElse(null)).ipAddress(node.getLocalSocketAddress().getHostString()).portNumber(node.getLocalSocketAddress().getPort());
    }

    private NodeState determineNodeState(NodeZduInfo info) {
        boolean isUpgradeModeEnabled = this.zduManager.getUpgradeStatus().getState() == ZduStatus.State.ENABLED;
        return switch (info.getApplicationState()) {
            default -> throw new MatchException(null, null);
            case ApplicationState.FIRST_RUN, ApplicationState.ERROR -> NodeState.ERROR;
            case ApplicationState.STARTING -> NodeState.STARTING;
            case ApplicationState.STOPPING -> NodeState.TERMINATING;
            case ApplicationState.RUNNING -> {
                if (isUpgradeModeEnabled) {
                    yield NodeState.ACTIVE;
                }
                boolean hasPendingTasks = info.isPendingLocalFinalization() || this.hasClusterFinalizationTasks();
                yield info.getFinalizationRun().filter(UpgradeFinalizationRun::isCompleted).map(r -> r.isFailed() ? NodeState.UPGRADE_TASKS_FAILED : NodeState.ACTIVE).orElse(hasPendingTasks ? NodeState.RUNNING_FINALIZE_UPGRADE_TASKS : NodeState.ACTIVE);
            }
        };
    }

    @VisibleForTesting
    static UpgradeTaskError convertToUpgradeTaskError(UpgradeFinalizationRun.Error error) {
        return new FinalizationUpgradeTaskErrorDTO(error.getUpgradeTaskName(), error.getExceptionMessage(), error.isClusterWideTask(), new ArrayList<String>(error.getUpgradeErrors()));
    }
}

