/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.zdu.rest.dto;

import com.atlassian.zdu.internal.api.UpgradeTaskError;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;

@Schema(name="UpgradeTaskError", description="Represents a Finalization Upgrade Task error.")
public class FinalizationUpgradeTaskErrorDTO
implements UpgradeTaskError {
    @Schema(description="The name of the task from which the error originated, or null if it occurred before performing finalization upgrade tasks.")
    private final String taskName;
    @Schema(description="The exception message of the error.")
    private final String exceptionMessage;
    @Schema(description="True if finalization upgrade task was cluster wide and false if local to the node.")
    private final boolean clusterUpgradeTask;
    @Schema(description="A list of errors resulting from the failed finalization upgrade task, or empty if none returned.")
    private final List<String> errors;

    public FinalizationUpgradeTaskErrorDTO(@JsonProperty(value="taskName") @Nullable String taskName, @JsonProperty(value="exceptionMessage") @Nonnull String exceptionMessage, @JsonProperty(value="clusterUpgradeTask") boolean isClusterUpgradeTask, @JsonProperty(value="errors") @Nonnull List<String> errors) {
        this.taskName = taskName;
        this.exceptionMessage = Objects.requireNonNull(exceptionMessage);
        this.clusterUpgradeTask = isClusterUpgradeTask;
        this.errors = Objects.requireNonNull(errors);
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    @Override
    public boolean isClusterUpgradeTask() {
        return this.clusterUpgradeTask;
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FinalizationUpgradeTaskErrorDTO other = (FinalizationUpgradeTaskErrorDTO)o;
        return com.google.common.base.Objects.equal((Object)this.taskName, (Object)other.taskName) && com.google.common.base.Objects.equal((Object)this.exceptionMessage, (Object)other.exceptionMessage) && com.google.common.base.Objects.equal((Object)this.clusterUpgradeTask, (Object)other.clusterUpgradeTask) && com.google.common.base.Objects.equal(this.errors, other.errors);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.taskName, this.exceptionMessage, this.clusterUpgradeTask, this.errors});
    }
}

