/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.zdu.rest.dto;

import com.atlassian.zdu.internal.api.NodeFinalizationInfo;
import com.atlassian.zdu.internal.api.UpgradeTaskError;
import com.atlassian.zdu.json.UnixEpochJsonUtils;
import com.atlassian.zdu.rest.dto.FinalizationUpgradeTaskErrorDTO;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

@Schema(name="NodeFinalizationInfo", description="Finalization information of a cluster node.")
@JsonDeserialize(builder=Builder.class)
@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
public class NodeFinalizationInfoDTO
implements NodeFinalizationInfo {
    @Schema(description="Time when finalization was last requested on this node, epoch time in milliseconds", type="string", format="unix-timestamp-millis", example="1709297585456")
    private final Instant lastRequested;
    @Schema(description="True if this is the node that would run cluster-wide finalization tasks")
    private final boolean runsClusterWideTasks;
    @ArraySchema(arraySchema=@Schema(description="Any errors which occurred when performing finalization upgrade tasks."), schema=@Schema(implementation=FinalizationUpgradeTaskErrorDTO.class))
    private final List<UpgradeTaskError> errors;

    public NodeFinalizationInfoDTO(Builder builder) {
        this.lastRequested = builder.lastRequested;
        this.runsClusterWideTasks = builder.runsClusterWideTasks;
        this.errors = builder.errors;
    }

    @Override
    @JsonSerialize(using=UnixEpochJsonUtils.Serializer.class)
    public Instant getLastRequested() {
        return this.lastRequested;
    }

    @Override
    @JsonProperty(value="runsClusterWideTasks")
    public boolean runsClusterWideTasks() {
        return this.runsClusterWideTasks;
    }

    @Override
    public List<UpgradeTaskError> getErrors() {
        return this.errors;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonAutoDetect(setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Builder {
        private Instant lastRequested;
        private boolean runsClusterWideTasks;
        private List<UpgradeTaskError> errors = new ArrayList<UpgradeTaskError>();

        @JsonDeserialize(using=UnixEpochJsonUtils.Deserializer.class)
        public Builder lastRequested(Instant lastRequested) {
            this.lastRequested = lastRequested;
            return this;
        }

        public Builder runsClusterWideTasks(boolean clusterWide) {
            this.runsClusterWideTasks = clusterWide;
            return this;
        }

        @JsonDeserialize(contentAs=FinalizationUpgradeTaskErrorDTO.class)
        public Builder errors(List<UpgradeTaskError> errors) {
            this.errors = errors;
            return this;
        }

        public NodeFinalizationInfoDTO build() {
            return new NodeFinalizationInfoDTO(this);
        }
    }
}

