/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.zdu.rest.filter;

import com.atlassian.zdu.internal.api.ClusterManagerAdapter;
import com.atlassian.zdu.rest.filter.annotations.ClusteredOnly;
import jakarta.inject.Inject;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.ext.Provider;

@Provider
@ClusteredOnly
public class IsClusteredFilter
implements ContainerRequestFilter {
    private final ClusterManagerAdapter clusterManagerAdapter;

    @Inject
    public IsClusteredFilter(ClusterManagerAdapter clusterManagerAdapter) {
        this.clusterManagerAdapter = clusterManagerAdapter;
    }

    public void filter(ContainerRequestContext containerRequestContext) {
        if (!this.clusterManagerAdapter.isClustered()) {
            throw new NotAuthorizedException((Object)"Rolling upgrades feature requires a clustered installation.", new Object[0]);
        }
    }
}

