/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.serialblocklist.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;

public final class ClassUtil {
    private static final Function<Object, Class<?>> CLASS_FINDER = ClassUtil.buildClassFinder();
    private static final Predicate<Object> IS_CGLIB_PROXY = ClassUtil.buildIsCglibPredicate();

    private ClassUtil() {
    }

    private static Predicate<Object> buildIsCglibPredicate() {
        try {
            Class<?> aopUtilsClass = Class.forName("org.springframework.aop.support.AopUtils", false, ClassUtil.class.getClassLoader());
            Method isCglibProxyMethod = aopUtilsClass.getMethod("isCglibProxy", Object.class);
            return target -> {
                try {
                    return (Boolean)isCglibProxyMethod.invoke(null, target);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return any -> false;
        }
    }

    private static Function<Object, Class<?>> buildClassFinder() {
        try {
            Class<?> aopProxyUtilsClass = Class.forName("org.springframework.aop.framework.AopProxyUtils", false, ClassUtil.class.getClassLoader());
            Method ultimateTargetClassMethod = aopProxyUtilsClass.getMethod("ultimateTargetClass", Object.class);
            return target -> {
                try {
                    return (Class)ultimateTargetClassMethod.invoke(null, target);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return Object::getClass;
        }
    }

    public static Class<?> ultimateTargetClass(Object target) {
        return CLASS_FINDER.apply(target);
    }

    private static boolean isCglibProxyClass(Object object) {
        return IS_CGLIB_PROXY.test(object);
    }

    public static boolean checkObjectClass(Object object, Predicate<Class<?>> predicate) throws IllegalArgumentException {
        if (object == null || predicate == null) {
            throw new IllegalArgumentException("Object and predicate cannot be null");
        }
        Class<?> targetClass = object.getClass();
        if (ClassUtil.isCglibProxyClass(object)) {
            targetClass = ClassUtil.ultimateTargetClass(object);
        } else if (Proxy.isProxyClass(object.getClass())) {
            return Arrays.stream(object.getClass().getInterfaces()).allMatch(predicate);
        }
        return predicate.test(targetClass);
    }
}

