/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.activeobject.dao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.plugins.mobile.activeobject.dao.MobileOAuth2ConfigurationDao;
import com.atlassian.confluence.plugins.mobile.activeobject.entity.MobileOAuth2ConfigurationAO;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.springframework.stereotype.Component;

@Component
public class MobileOAuth2ConfigurationDaoImpl
implements MobileOAuth2ConfigurationDao {
    private final ActiveObjects activeObjects;

    public MobileOAuth2ConfigurationDaoImpl(@ComponentImport ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    @Override
    public Optional<MobileOAuth2ConfigurationAO> getConfiguration() {
        return Arrays.stream((MobileOAuth2ConfigurationAO[])this.activeObjects.find(MobileOAuth2ConfigurationAO.class)).findFirst();
    }

    @Override
    public MobileOAuth2ConfigurationAO saveConfiguration(@Nonnull Map<String, Object> configurationParameters) throws IllegalStateException {
        return (MobileOAuth2ConfigurationAO)this.activeObjects.create(MobileOAuth2ConfigurationAO.class, configurationParameters);
    }

    @Override
    public void deleteConfiguration() {
        this.activeObjects.executeInTransaction(() -> {
            MobileOAuth2ConfigurationAO[] configs = (MobileOAuth2ConfigurationAO[])this.activeObjects.find(MobileOAuth2ConfigurationAO.class, Query.select());
            Optional.ofNullable(configs).ifPresent(configurations -> {
                for (MobileOAuth2ConfigurationAO config : configurations) {
                    this.activeObjects.delete(new RawEntity[]{config});
                }
            });
            return null;
        });
    }

    @Override
    public void updateBrowserCacheFlag(Boolean status) {
        this.activeObjects.executeInTransaction(() -> {
            MobileOAuth2ConfigurationAO[] configs = (MobileOAuth2ConfigurationAO[])this.activeObjects.find(MobileOAuth2ConfigurationAO.class, Query.select());
            Optional.ofNullable(configs).ifPresent(configurations -> {
                for (MobileOAuth2ConfigurationAO config : configurations) {
                    config.setBrowserCacheEnabled(status);
                    config.save();
                }
            });
            return null;
        });
    }
}

