/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.condition;

import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.webresource.api.QueryParams;
import com.atlassian.webresource.api.url.UrlBuilder;
import com.atlassian.webresource.spi.condition.UrlReadingCondition;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;

public class MobileAppResourceCondition
implements UrlReadingCondition {
    private static final String MOBILE_APP_LOGIN_RESOURCE_QUERY_PARAM_KEY = "mobile-app-login-resource";
    private final HttpContext httpContext;

    public MobileAppResourceCondition(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public void addToUrl(UrlBuilder urlBuilder) {
        if (this.isMobileAppLogin()) {
            urlBuilder.addToQueryString(MOBILE_APP_LOGIN_RESOURCE_QUERY_PARAM_KEY, "true");
        }
    }

    public boolean shouldDisplay(QueryParams queryParams) {
        return Boolean.parseBoolean(queryParams.get(MOBILE_APP_LOGIN_RESOURCE_QUERY_PARAM_KEY));
    }

    private boolean isMobileAppLogin() {
        HttpServletRequest request = this.httpContext.getActiveRequest();
        if (request == null) {
            return false;
        }
        String userAgent = request.getHeader("User-Agent");
        return userAgent != null && userAgent.contains("AtlassianMobileApp");
    }
}

