/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.contextprovider;

import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.util.MobileUtils;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.ContextProvider;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;

public class MobileAppBannerContextProvider
implements ContextProvider {
    private static final String CONFLUENCE_MOBILE_SCHEME = "confluence-server://";
    private static final String VIEW_PAGE_URL_REG = "^/pages/viewpage\\.action?.*";
    private static final String ANDROID_MANIFEST_PATH = "download/resources/com.atlassian.confluence.plugins.confluence-mobile-plugin:mobile-app-banner-web-resource/manifest.json";
    private static final String IOS_APP_ID = "1288365159";
    private static final String OS_DESTINATION = "os_destination";
    private final GlobalSettingsManager settingsManager;
    private final HttpContext httpContext;

    public MobileAppBannerContextProvider(@ComponentImport @Qualifier(value="globalSettingsManager") GlobalSettingsManager settingsManager, HttpContext httpContext) {
        this.settingsManager = settingsManager;
        this.httpContext = httpContext;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        HttpServletRequest request = this.httpContext.getActiveRequest();
        if (request == null) {
            return context;
        }
        MobileUtils.MobileOS os = MobileUtils.getMobileOS((HttpServletRequest)request);
        if (os == MobileUtils.MobileOS.ANDROID) {
            context.put("os", MobileUtils.MobileOS.ANDROID.getValue());
            context.put("manifest", ANDROID_MANIFEST_PATH);
        } else if (os == MobileUtils.MobileOS.IOS) {
            context.put("os", MobileUtils.MobileOS.IOS.getValue());
            context.put("appId", IOS_APP_ID);
            context.put("appArgument", this.getAppArgument(request));
        }
        return context;
    }

    private String getAppArgument(HttpServletRequest request) {
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        if (StringUtils.isBlank((CharSequence)baseUrl)) {
            return CONFLUENCE_MOBILE_SCHEME;
        }
        String appArgument = baseUrl.replaceFirst("http://|https://", CONFLUENCE_MOBILE_SCHEME);
        String osDestination = request.getParameter(OS_DESTINATION);
        if (StringUtils.isBlank((CharSequence)osDestination)) {
            return appArgument;
        }
        if (osDestination.matches(VIEW_PAGE_URL_REG)) {
            return appArgument + osDestination;
        }
        return appArgument + "?os_destination=" + osDestination;
    }
}

