/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.contextprovider;

import com.atlassian.confluence.plugins.mobile.dto.OAuth2ConfigurationDto;
import com.atlassian.confluence.plugins.mobile.notification.PushNotificationStatus;
import com.atlassian.confluence.plugins.mobile.service.MobileOAuth2ConfigurationService;
import com.atlassian.confluence.plugins.mobile.service.PushNotificationService;
import com.atlassian.confluence.util.i18n.UserI18NBeanFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.web.ContextProvider;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class MobileConfigurationContextProvider
implements ContextProvider {
    public static final String OAUTH2_PROVIDER_PLUGIN_KEY = "com.atlassian.oauth2.oauth2-provider-plugin";
    private final UserI18NBeanFactory i18NBeanFactory;
    private final PushNotificationService pushNotificationService;
    private final MobileOAuth2ConfigurationService oAuth2ConfigurationService;
    private final PluginAccessor pluginAccessor;

    public MobileConfigurationContextProvider(UserI18NBeanFactory i18NBeanFactory, PushNotificationService pushNotificationService, PluginAccessor pluginAccessor, MobileOAuth2ConfigurationService oAuth2ConfigurationService) {
        this.i18NBeanFactory = i18NBeanFactory;
        this.pushNotificationService = pushNotificationService;
        this.pluginAccessor = pluginAccessor;
        this.oAuth2ConfigurationService = oAuth2ConfigurationService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        context.put("i18n", this.i18NBeanFactory.getI18NBean());
        boolean isWorkBoxPluginDisabled = !this.pluginAccessor.isPluginEnabled("com.atlassian.mywork.mywork-confluence-host-plugin");
        context.put("isWorkBoxPluginDisabled", isWorkBoxPluginDisabled);
        context.put("isPushNotificationEnabled", !isWorkBoxPluginDisabled && this.pushNotificationService.getStatus() == PushNotificationStatus.ENABLED);
        context.put("isOAuth2Enabled", this.isOauth2Enabled());
        context.put("isOauth2Available", this.isOauth2Available());
        context.put("isBrowserCacheEnabled", this.isBrowserCacheEnabled());
        return context;
    }

    public boolean isOauth2Enabled() {
        return this.oAuth2ConfigurationService.getConfiguration().isPresent();
    }

    public boolean isBrowserCacheEnabled() {
        Optional<OAuth2ConfigurationDto> oauth2Configuration = this.oAuth2ConfigurationService.getConfiguration();
        return oauth2Configuration.map(OAuth2ConfigurationDto::getCacheSessionInMobileBrowser).orElse(false);
    }

    public boolean isOauth2Available() {
        Plugin oauth2ProviderPlugin = this.pluginAccessor.getPlugin(OAUTH2_PROVIDER_PLUGIN_KEY);
        return Objects.nonNull(oauth2ProviderPlugin) && PluginState.ENABLED.equals((Object)oauth2ProviderPlugin.getPluginState());
    }
}

