/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.dto;

import com.atlassian.confluence.plugins.mobile.activeobject.entity.MobileOAuth2ConfigurationAO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class OAuth2ConfigurationDto {
    @JsonIgnore
    private String configId;
    @JsonProperty
    private String clientId;
    @JsonProperty
    private boolean cacheSessionInMobileBrowser;

    public OAuth2ConfigurationDto() {
    }

    public OAuth2ConfigurationDto(String configId, String clientId, boolean cacheSessionInMobileBrowser) {
        this.configId = configId;
        this.clientId = clientId;
        this.cacheSessionInMobileBrowser = cacheSessionInMobileBrowser;
    }

    public static OAuth2ConfigurationDto from(MobileOAuth2ConfigurationAO config) {
        return new OAuth2ConfigurationDto(config.getConfigurationId(), config.getClientId(), config.isBrowserCacheEnabled());
    }

    public String getConfigId() {
        return this.configId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public boolean getCacheSessionInMobileBrowser() {
        return this.cacheSessionInMobileBrowser;
    }

    public void setConfigId(String configId) {
        this.configId = configId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setCacheSessionInMobileBrowser(boolean cacheSessionInMobileBrowser) {
        this.cacheSessionInMobileBrowser = cacheSessionInMobileBrowser;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2ConfigurationDto that = (OAuth2ConfigurationDto)o;
        return Objects.equals(this.configId, that.configId) && Objects.equals(this.clientId, that.clientId) && Objects.equals(this.cacheSessionInMobileBrowser, that.cacheSessionInMobileBrowser);
    }

    public int hashCode() {
        return Objects.hash(this.configId, this.clientId, this.cacheSessionInMobileBrowser);
    }

    public String toString() {
        return "OAuth2ConfigurationDto{configId='" + this.configId + "', clientId='" + this.clientId + "', cacheSessionInMobileBrowser=" + this.cacheSessionInMobileBrowser + "}";
    }
}

