/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.restapi.v1_0;

import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.plugins.mobile.model.card.Card;
import com.atlassian.confluence.plugins.mobile.service.CardService;
import com.atlassian.confluence.plugins.mobile.service.impl.CardServiceImpl;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.springframework.stereotype.Component;

@Tag(name="Activity API", description="Contains all operations related to Activities")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/card")
@Component
public class CardResource {
    private final CardService cardService;

    @Inject
    public CardResource(CardService cardService) {
        this.cardService = cardService;
    }

    @Operation(summary="Get activities", description="Gets a list of activities by a space key", responses={@ApiResponse(responseCode="200", description="List of Activities", content={@Content(array=@ArraySchema(schema=@Schema(implementation=CardServiceImpl.CardPageResponse.class)))})})
    @GET
    public PageResponse<Card> getCards(@QueryParam(value="expand") String expand, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="start") @DefaultValue(value="0") int start, @QueryParam(value="limit") @DefaultValue(value="50") int limit) {
        return this.cardService.find().expand(new Expansions(ExpansionsParser.parse((String)expand))).spaceKey(spaceKey).fetchMany((PageRequest)new SimplePageRequest(start, limit));
    }
}

