/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.restapi.v1_0;

import com.atlassian.confluence.plugins.mobile.dto.LinkExtractorDto;
import com.atlassian.confluence.plugins.mobile.service.LinkExtractorService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.springframework.stereotype.Component;

@Tag(name="Link API", description="Contains all operations related to links")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/linkextractor")
@Component
public class LinkResource {
    private final LinkExtractorService linkExtractorService;

    @Inject
    public LinkResource(LinkExtractorService linkExtractorService) {
        this.linkExtractorService = linkExtractorService;
    }

    @Operation(summary="Get link details", description="Get the page and comment Ids from a confluence URL", responses={@ApiResponse(responseCode="200", description="Page and comment Ids", content={@Content(schema=@Schema(implementation=LinkExtractorDto.class))})})
    @GET
    public LinkExtractorDto getLinkExtractor(@QueryParam(value="link") String link) {
        return this.linkExtractorService.extractor(link);
    }
}

