/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.restapi.v1_0;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.actions.AuthenticationHelper;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Tag(name="Logout API", description="Logout user resource")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/session")
@Component
public class LogoutResource {
    private final Logger logger = LoggerFactory.getLogger(LogoutResource.class);
    private final EventPublisher eventPublisher;
    private final HttpContext httpContext;

    @Inject
    public LogoutResource(@ComponentImport EventPublisher eventPublisher, @ComponentImport HttpContext httpContext) {
        this.eventPublisher = eventPublisher;
        this.httpContext = httpContext;
    }

    @Operation(summary="Logout", description="Logs out current user", responses={@ApiResponse(responseCode="204", description="Successfully logged out"), @ApiResponse(responseCode="401", description="User unauthorized")})
    @DELETE
    @Path(value="/logout")
    public Response logout() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        boolean isLoggedOut = AuthenticationHelper.userLogout((Principal)user, (HttpServletRequest)this.httpContext.getActiveRequest(), (HttpServletResponse)this.httpContext.getActiveResponse(), (EventPublisher)this.eventPublisher, (Object)this);
        if (!isLoggedOut) {
            this.logger.error("Couldn't logged out the user {}", (Object)user);
        } else {
            this.logger.info("The user {} has been logged out.", (Object)user);
        }
        return Response.noContent().build();
    }
}

