/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.restapi.v1_0;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.confluence.plugins.mobile.service.MobileOAuth2ConfigurationService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Tag(name="OAuth API", description="Contains all APIs related to configuring OAuth2 Flow for mobile clients")
@Path(value="/oauth2")
@Produces(value={"application/json"})
@AdminOnly
public class MobileOAuth2Resource {
    public static final String OAUTH2_FEATURE_ENABLED_SUCCESSFULLY = "OAuth2 is enabled successfully. Mobile associated application link is created!";
    public static final String OAUTH2_FEATURE_DISABLED_SUCCESSFULLY = "OAuth2 is disabled successfully. Mobile associated application link is removed!";
    public static final String MOBILE_CACHE_ENABLED_SUCCESSFULLY = "Mobile cache is enabled successfully.";
    public static final String MOBILE_CACHE_DISABLED_SUCCESSFULLY = "Mobile cache is disabled successfully.";
    private final MobileOAuth2ConfigurationService oAuth2Service;

    @Inject
    public MobileOAuth2Resource(MobileOAuth2ConfigurationService oAuth2Service) {
        this.oAuth2Service = oAuth2Service;
    }

    @Operation(description="Enables OAuth2 login flow for mobile clients", responses={@ApiResponse(responseCode="200", description="OAuth2 flow was successfully enabled, related Incoming Link created"), @ApiResponse(responseCode="401", description="User have to be authenticated to perform this action"), @ApiResponse(responseCode="403", description="Administrator permission needed to perform this action"), @ApiResponse(responseCode="409", description="OAuth2 flow is already enabled!")})
    @POST
    @Path(value="/enable")
    public Response enable() {
        this.oAuth2Service.createConfiguration();
        return Response.ok((Object)OAUTH2_FEATURE_ENABLED_SUCCESSFULLY).build();
    }

    @Operation(description="Disables OAuth2 login flow for mobile clients", responses={@ApiResponse(responseCode="200", description="OAuth2 flow was successfully disabled, related Incoming Link removed"), @ApiResponse(responseCode="401", description="User is unauthorized to perform this action"), @ApiResponse(responseCode="403", description="User does not have permission to disable oauth2 flow"), @ApiResponse(responseCode="409", description="This response code can be given when: | user tries to disable flow but it is already disabled| the application link was not removed completely")})
    @POST
    @Path(value="/disable")
    public Response disable() {
        this.oAuth2Service.removeConfiguration();
        return Response.ok((Object)OAUTH2_FEATURE_DISABLED_SUCCESSFULLY).build();
    }

    @Operation(description="Enables mobile browser cache", responses={@ApiResponse(responseCode="200", description="Mobile cache was successfully enabled"), @ApiResponse(responseCode="401", description="User must be authenticated to perform this action"), @ApiResponse(responseCode="403", description="Administrator permission needed to perform this action"), @ApiResponse(responseCode="404", description="Failed to enable cache session flag: Configuration not found.")})
    @POST
    @Path(value="/cache/enable")
    public Response cacheEnable() {
        this.oAuth2Service.enableMobileBrowserCache();
        return Response.ok((Object)MOBILE_CACHE_ENABLED_SUCCESSFULLY).build();
    }

    @Operation(description="Disables mobile browser cache", responses={@ApiResponse(responseCode="200", description="Mobile cache was successfully disabled"), @ApiResponse(responseCode="401", description="User must be authenticated to perform this action"), @ApiResponse(responseCode="403", description="Administrator permission needed to perform this action"), @ApiResponse(responseCode="404", description="Failed to disable cache session flag: Configuration not found.")})
    @POST
    @Path(value="/cache/disable")
    public Response cacheDisable() {
        this.oAuth2Service.disableMobileBrowserCache();
        return Response.ok((Object)MOBILE_CACHE_DISABLED_SUCCESSFULLY).build();
    }
}

