/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.service.impl;

import com.atlassian.confluence.plugins.mobile.dto.LoginInfoDto;
import com.atlassian.confluence.plugins.mobile.dto.OAuth2ConfigurationDto;
import com.atlassian.confluence.plugins.mobile.dto.ServerInfoDto;
import com.atlassian.confluence.plugins.mobile.notification.PushNotificationStatus;
import com.atlassian.confluence.plugins.mobile.service.MobileFeatureManager;
import com.atlassian.confluence.plugins.mobile.service.MobileInfoService;
import com.atlassian.confluence.plugins.mobile.service.MobileOAuth2ConfigurationService;
import com.atlassian.confluence.plugins.mobile.service.PushNotificationService;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class MobileInfoServiceImpl
implements MobileInfoService {
    public static final String OAUTH2_PROVIDER_PLUGIN_KEY = "com.atlassian.oauth2.oauth2-provider-plugin";
    private final GlobalSettingsManager settingsManager;
    private final PluginAccessor pluginAccessor;
    private final PushNotificationService pushNotificationService;
    private final MobileFeatureManager mobileFeatureManager;
    private final MobileOAuth2ConfigurationService mobileOAuth2ConfigurationService;

    @Autowired
    public MobileInfoServiceImpl(@ComponentImport @Qualifier(value="globalSettingsManager") GlobalSettingsManager settingsManager, @ComponentImport PluginAccessor pluginAccessor, PushNotificationService pushNotificationService, MobileFeatureManager mobileFeatureManager, MobileOAuth2ConfigurationService mobileOAuth2ConfigurationService) {
        this.settingsManager = settingsManager;
        this.pluginAccessor = pluginAccessor;
        this.pushNotificationService = pushNotificationService;
        this.mobileFeatureManager = mobileFeatureManager;
        this.mobileOAuth2ConfigurationService = mobileOAuth2ConfigurationService;
    }

    @Override
    public LoginInfoDto getLoginInfo() {
        Settings globalSettings = this.settingsManager.getGlobalSettings();
        String siteTitle = globalSettings.getSiteTitle();
        String baseUrl = globalSettings.getBaseUrl();
        Optional<OAuth2ConfigurationDto> oAuth2Config = this.getOAuth2Configuration();
        return new LoginInfoDto(siteTitle, baseUrl, oAuth2Config.orElse(null));
    }

    @Override
    public ServerInfoDto getServerInfo() {
        return ServerInfoDto.builder().pushNotificationEnabled(this.pushNotificationService.getStatus() == PushNotificationStatus.ENABLED).sessionTimeoutFixEnabled(this.mobileFeatureManager.isStatusCodeRewritingEnabled()).build();
    }

    private Optional<OAuth2ConfigurationDto> getOAuth2Configuration() {
        return this.isOAuth2PluginEnabled() ? this.mobileOAuth2ConfigurationService.getConfiguration() : Optional.empty();
    }

    private boolean isOAuth2PluginEnabled() {
        Plugin oauth2Plugin = this.pluginAccessor.getPlugin(OAUTH2_PROVIDER_PLUGIN_KEY);
        if (Objects.isNull(oauth2Plugin)) {
            return false;
        }
        PluginState oauth2PluginState = oauth2Plugin.getPluginState();
        return PluginState.ENABLED.equals((Object)oauth2PluginState);
    }
}

