/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.service.impl;

import com.atlassian.confluence.api.service.exceptions.ConflictException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.plugins.mobile.activeobject.dao.MobileOAuth2ConfigurationDao;
import com.atlassian.confluence.plugins.mobile.activeobject.entity.MobileOAuth2ConfigurationAO;
import com.atlassian.confluence.plugins.mobile.dto.OAuth2ConfigurationDto;
import com.atlassian.confluence.plugins.mobile.service.MobileOAuth2ConfigurationService;
import com.atlassian.oauth2.provider.api.client.Client;
import com.atlassian.oauth2.provider.api.client.ClientService;
import com.atlassian.oauth2.scopes.api.ScopeResolver;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.security.random.DefaultSecureRandomService;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MobileOAuth2ConfigurationServiceImpl
implements MobileOAuth2ConfigurationService {
    public static final String MOBILE_CONFIGURATION_REDIRECT_URL = "confluence-server://oauth-callback";
    public static final String MOBILE_CONFIGURATION_NAME = "Confluence Mobile Plugin";
    public static final String MOBILE_CONFIGURATION_SCOPE_NAME = "WRITE";
    public static final boolean DEFAULT_BROWSER_CACHING_PREFERENCE = false;
    private ClientService clientService;
    private MobileOAuth2ConfigurationDao mobileOAuth2ConfigurationDao;
    private ScopeResolver scopeResolver;

    @Autowired
    public MobileOAuth2ConfigurationServiceImpl(@ComponentImport ClientService clientService, @ComponentImport ScopeResolver scopeResolver, MobileOAuth2ConfigurationDao mobileOAuth2ConfigurationDao) {
        this.clientService = clientService;
        this.mobileOAuth2ConfigurationDao = mobileOAuth2ConfigurationDao;
        this.scopeResolver = scopeResolver;
    }

    @Override
    public void createConfiguration() {
        Optional<MobileOAuth2ConfigurationAO> configuration = this.mobileOAuth2ConfigurationDao.getConfiguration();
        if (configuration.isEmpty()) {
            this.createOauth2Configuration();
        } else {
            Optional client = this.clientService.getById(configuration.get().getConfigurationId());
            if (client.isPresent()) {
                throw new ConflictException("Mobile oauth2 configuration was already created!");
            }
            this.mobileOAuth2ConfigurationDao.deleteConfiguration();
            this.createOauth2Configuration();
        }
    }

    @Override
    public void removeConfiguration() {
        Optional<MobileOAuth2ConfigurationAO> configuration = this.mobileOAuth2ConfigurationDao.getConfiguration();
        if (configuration.isEmpty()) {
            throw new ConflictException("Mobile oauth2 configuration is already removed!");
        }
        Optional removedClientConfiguration = this.clientService.removeById(configuration.get().getConfigurationId());
        removedClientConfiguration.ifPresentOrElse(client -> this.mobileOAuth2ConfigurationDao.deleteConfiguration(), () -> {
            throw new ConflictException("Mobile associated application link was not removed!");
        });
    }

    @Override
    public void enableMobileBrowserCache() {
        this.updateCacheSessionFlagStatus(true);
    }

    @Override
    public void disableMobileBrowserCache() {
        this.updateCacheSessionFlagStatus(false);
    }

    private void updateCacheSessionFlagStatus(boolean newStatus) {
        MobileOAuth2ConfigurationAO configuration = this.fetchMobileOAuth2Configuration().orElseThrow(() -> new NotFoundException("Failed to update cache session flag: Configuration not found."));
        if (configuration.isBrowserCacheEnabled() != newStatus) {
            this.mobileOAuth2ConfigurationDao.updateBrowserCacheFlag(newStatus);
        }
    }

    private Optional<MobileOAuth2ConfigurationAO> fetchMobileOAuth2Configuration() {
        return this.mobileOAuth2ConfigurationDao.getConfiguration();
    }

    @Override
    public Optional<OAuth2ConfigurationDto> getConfiguration() {
        Optional<MobileOAuth2ConfigurationAO> configuration = this.mobileOAuth2ConfigurationDao.getConfiguration();
        return configuration.map(OAuth2ConfigurationDto::from);
    }

    private Map<String, Object> parametersFrom(@Nonnull Client client, boolean useEphemeralSession) {
        return Map.of("CONFIGURATION_ID", client.getId(), "CLIENT_ID", client.getClientId(), "BROWSER_CACHE_ENABLED", useEphemeralSession);
    }

    private MobileOAuth2ConfigurationAO createOauth2Configuration() {
        Client createdClient = this.clientService.create(this.generateLinkName(), this.scopeResolver.getScope(MOBILE_CONFIGURATION_SCOPE_NAME), Collections.singletonList(MOBILE_CONFIGURATION_REDIRECT_URL));
        return this.mobileOAuth2ConfigurationDao.saveConfiguration(this.parametersFrom(createdClient, false));
    }

    private String generateLinkName() {
        return "Confluence Mobile Plugin_" + Math.abs(DefaultSecureRandomService.getInstance().nextInt());
    }
}

