/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.internal;

import com.atlassian.diagnostics.Alert;
import com.atlassian.diagnostics.AlertListener;
import com.atlassian.diagnostics.internal.dao.AlertEntityDao;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class PersistingAlertListener
implements AlertListener {
    private final AlertEntityDao dao;
    private final TransactionTemplate transactionTemplate;

    public PersistingAlertListener(@Nonnull AlertEntityDao dao, @Nonnull TransactionTemplate transactionTemplate) {
        this.dao = Objects.requireNonNull(dao, "dao");
        this.transactionTemplate = Objects.requireNonNull(transactionTemplate, "transactionTemplate");
    }

    public void onAlert(@Nonnull Alert alert) {
        this.transactionTemplate.execute(() -> {
            this.dao.save(alert);
            return null;
        });
    }
}

