/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.internal.ipd;

import com.atlassian.diagnostics.ipd.api.CachedIpdState;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistration;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRunner;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIpdJobRunner
implements IpdJobRunner,
IpdJobRegistry {
    private static final Logger log = LoggerFactory.getLogger(DefaultIpdJobRunner.class);
    protected final Map<Class<?>, IpdJobRegistration> jobs;
    private final CachedIpdState cachedIpdState;

    protected DefaultIpdJobRunner(CachedIpdState cachedIpdState) {
        this.cachedIpdState = cachedIpdState;
        this.jobs = new ConcurrentHashMap();
    }

    public void register(@Nonnull IpdJob job, @Nonnull String key) {
        this.register(IpdJobRegistration.builder((IpdJob)job, (String)key).build());
    }

    public void register(@Nonnull IpdJobRegistration jobRegistration) {
        this.jobs.put(jobRegistration.getIpdJob().getClass(), jobRegistration);
        log.info("IPD Job {} has been registered", (Object)jobRegistration.getIpdJob().getClass().getName());
    }

    public void unregister(@Nonnull Class<? extends IpdJob> jobClass) {
        this.jobs.remove(jobClass);
        log.info("IPD Job {} has been unregistered", (Object)jobClass.getName());
    }

    public void runJobs() throws InterruptedException {
        if (!this.cachedIpdState.isIpdEnabled()) {
            log.debug("Not executing IpdJobs because in.product.diagnostics feature flag is disabled");
            return;
        }
        for (IpdJobRegistration registration : this.jobs.values()) {
            if (Thread.interrupted()) {
                log.info("Thread was interrupted, stopping IPD jobs execution");
                throw new InterruptedException();
            }
            try {
                IpdJob job = registration.getIpdJob();
                if (registration.isWorkInProgress() && !this.cachedIpdState.isWipIpdEnabled()) {
                    log.debug("Ignoring job {}, in.product.diagnostics.wip feature flag is not enabled", (Object)job.getClass().getName());
                    continue;
                }
                log.debug("Running job {}", (Object)job.getClass().getName());
                job.runJob();
            }
            catch (RuntimeException ex) {
                log.error(String.format("Error during executing %s job", registration.getIpdJob().getClass().getName()), (Throwable)ex);
            }
        }
    }

    public void shutdown() {
        this.jobs.clear();
    }
}

