/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.internal.ipd;

import com.atlassian.diagnostics.ipd.api.CachedIpdState;
import com.atlassian.diagnostics.ipd.api.IpdLoggingService;
import com.atlassian.diagnostics.ipd.api.MeterKey;
import com.atlassian.diagnostics.ipd.api.meters.IpdMeter;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterConfig;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.time.Clock;
import java.time.Instant;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class DefaultLoggingService
implements IpdLoggingService {
    private final Logger regularLogger = LoggerFactory.getLogger((String)"ipd-monitoring");
    private static final ObjectMapper objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private final CachedIpdState cachedIpdState;
    private final Clock clock;

    public DefaultLoggingService(CachedIpdState cachedIpdState) {
        this(cachedIpdState, Clock.systemUTC());
    }

    public DefaultLoggingService(CachedIpdState cachedIpdState, Clock clock) {
        this.cachedIpdState = cachedIpdState;
        this.clock = clock;
    }

    public void logMetric(IpdMeter meter) {
        this.logMetric(meter, this.clock.instant());
    }

    public void logMetric(IpdMeter meter, Instant timestamp) {
        if (!meter.isEnabled() || !meter.isVisible()) {
            return;
        }
        MeterConfig config = meter.getConfig();
        if (!config.getLoggingCondition().test(meter)) {
            return;
        }
        this.forceLogMetric(meter, timestamp);
    }

    public void forceLogMetric(IpdMeter meter, Instant timestamp) {
        boolean extraLogging = this.cachedIpdState.isIpdExtraLoggingEnabled();
        Map attributes = meter.getAttributes(extraLogging);
        if (attributes.isEmpty()) {
            return;
        }
        IpdLogEntry logEntry = new IpdLogEntry(String.valueOf(timestamp.getEpochSecond()), meter.getMeterKey(), extraLogging ? meter.getObjectName().getCanonicalName() : null, attributes);
        try {
            Logger logger = meter.getConfig().getLogger();
            if (logger.isInfoEnabled()) {
                logger.info(this.formatData(objectMapper.writeValueAsString((Object)logEntry)));
            }
        }
        catch (JsonProcessingException e) {
            this.regularLogger.warn("Can't serialize Jmx instrument: {}", (Object)logEntry);
        }
    }

    protected String formatData(String data) {
        return "IPDMONITORING " + data;
    }

    static class IpdLogEntry {
        private final String timestamp;
        private final String label;
        private final String objectName;
        private final Map<String, String> tags;
        private final Object attributes;

        public IpdLogEntry(String timestamp, MeterKey meterKey, @Nullable String objectName, Object attributes) {
            this.timestamp = timestamp;
            this.label = meterKey.getName().toUpperCase();
            this.objectName = objectName;
            this.tags = meterKey.getTagsAsMap().isEmpty() ? null : meterKey.getFormattedTagsAsMap();
            this.attributes = attributes;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public String getLabel() {
            return this.label;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public Map<String, String> getTags() {
            return this.tags;
        }

        public Object getAttributes() {
            return this.attributes;
        }
    }
}

