/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.internal.ipd;

import com.atlassian.diagnostics.internal.ipd.IpdMeterRegistry;
import com.atlassian.diagnostics.ipd.api.MeterConfigurations;
import com.atlassian.diagnostics.ipd.api.MeterKey;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterConfigBuilder;
import com.atlassian.diagnostics.ipd.api.meters.config.ProductMeterConfigBuilder;
import jakarta.annotation.PreDestroy;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginAwareIpdRegistry
extends IpdMeterRegistry {
    private static final String PLUGIN_KEY = "pluginKey";
    private static final Logger LOG = LoggerFactory.getLogger(PluginAwareIpdRegistry.class);
    private final IpdMeterRegistry delegate;
    private final String pluginName;

    public PluginAwareIpdRegistry(String pluginName, IpdMeterRegistry delegate, MeterConfigurations pluginMeterConfigurations) {
        super(new DelegateMeterConfigurations(delegate.getMeterConfigurations(), pluginMeterConfigurations), delegate.getMetersStorage());
        this.pluginName = pluginName;
        this.delegate = delegate;
        pluginMeterConfigurations.addMeterConfig("", b -> b.setProperty(PLUGIN_KEY, (Object)pluginName));
    }

    @PreDestroy
    public void preDestroy() {
        this.shutdown();
    }

    public void shutdown() {
        this.delegate.removeIf(meter -> this.pluginName.equals(meter.getConfig().getProperties().get(PLUGIN_KEY)));
        LOG.info("Unregistering ipd meters for plugin: {}", (Object)this.pluginName);
    }

    private static class DelegateMeterConfigurations
    implements MeterConfigurations {
        private final MeterConfigurations mainConfiguration;
        private final MeterConfigurations extraConfiguration;

        public DelegateMeterConfigurations(MeterConfigurations mainConfiguration, MeterConfigurations extraConfiguration) {
            this.mainConfiguration = mainConfiguration;
            this.extraConfiguration = extraConfiguration;
        }

        public MeterConfigurations addMeterConfig(String prefixMatcher, Consumer<MeterConfigBuilder> meterConfig) {
            this.extraConfiguration.addMeterConfig(prefixMatcher, meterConfig);
            return this;
        }

        public void evaluateConfig(MeterKey meterKey, ProductMeterConfigBuilder configBuilder) {
            this.mainConfiguration.evaluateConfig(meterKey, configBuilder);
            this.extraConfiguration.evaluateConfig(meterKey, configBuilder);
        }
    }
}

