/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.internal.ipd.metrics;

import com.atlassian.diagnostics.internal.ipd.metrics.IpdProfilingMeter;
import com.atlassian.diagnostics.internal.jmx.ReadOnlyProxyMBean;
import com.atlassian.diagnostics.ipd.api.meters.JmxCopyMeter;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterConfig;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterFactory;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegisterException;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Map;
import javax.management.DynamicMBean;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxCopyMeterImpl
extends IpdProfilingMeter
implements JmxCopyMeter {
    private static final Logger LOG = LoggerFactory.getLogger(JmxCopyMeterImpl.class);
    private final ObjectName sourceBeanName;
    private final DynamicMBean jmxBean;

    protected JmxCopyMeterImpl(MeterConfig config, MBeanServer mBeanServer, ObjectName sourceBeanName, List<String> allAttributes, List<String> shortAttributes) {
        super(config, mBeanServer, allAttributes, shortAttributes);
        this.sourceBeanName = sourceBeanName;
        this.jmxBean = new ReadOnlyProxyMBean(sourceBeanName, mBeanServer);
        this.registerMBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerMBean() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.mBeanServer.isRegistered(this.getObjectName())) {
            this.jmxRegistered.set(true);
        } else {
            JmxCopyMeterImpl jmxCopyMeterImpl = this;
            synchronized (jmxCopyMeterImpl) {
                if (!this.jmxRegistered.get()) {
                    try {
                        this.mBeanServer.registerMBean(this.jmxBean, this.getObjectName());
                        this.jmxRegistered.set(true);
                    }
                    catch (Exception e) {
                        throw new IpdRegisterException(String.format("Unable to register JMX bean for metric %s", this.getMeterKey().getName()), (Throwable)e);
                    }
                }
            }
        }
    }

    private boolean sourceBeanExists() {
        return this.mBeanServer.isRegistered(this.sourceBeanName);
    }

    public void update() {
        if (!this.sourceBeanExists()) {
            this.unregisterMBean();
            this.removeJmxBeanIfExists();
        } else {
            this.registerMBean();
            this.metricUpdated();
        }
    }

    private void removeJmxBeanIfExists() {
        try {
            if (this.mBeanServer.isRegistered(this.getObjectName())) {
                this.mBeanServer.unregisterMBean(this.getObjectName());
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to unregister JMX bean for metric {}", (Object)this.getMeterKey().getName(), (Object)e);
        }
    }

    @Override
    public Map<String, Object> getAttributes(boolean extraAttributes) {
        return this.getAttributes(extraAttributes, this.sourceBeanName);
    }

    @Override
    public void unregisterMBean() {
        if (!this.jmxRegistered.compareAndSet(true, false)) {
            return;
        }
        this.removeJmxBeanIfExists();
    }

    public static MeterFactory<JmxCopyMeter> factory(ObjectName sourceBeanName, List<String> allAttributes, List<String> shortAttributes) {
        return new MeterFactory(config -> JmxCopyMeterImpl.create(sourceBeanName, config, allAttributes, shortAttributes), "jmx-copy", "");
    }

    private static JmxCopyMeterImpl create(ObjectName objectToCopy, MeterConfig config, List<String> allAttributes, List<String> shortAttributes) {
        return new JmxCopyMeterImpl(config, ManagementFactory.getPlatformMBeanServer(), objectToCopy, allAttributes, shortAttributes);
    }
}

